/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener.adapter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Address;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;

public class DelegatingInvocableHandler {
    private static final ThreadLocal<Address> defaultReplyTo = new ThreadLocal();
    private final List<InvocableHandlerMethod> handlers;
    private final ConcurrentMap<Class<?>, InvocableHandlerMethod> cachedHandlers = new ConcurrentHashMap();
    private final Map<InvocableHandlerMethod, Address> defaultReplyToForHandler = new HashMap<InvocableHandlerMethod, Address>();
    private final Object bean;
    private final BeanExpressionResolver resolver;
    private final BeanExpressionContext beanExpressionContext;

    public DelegatingInvocableHandler(List<InvocableHandlerMethod> handlers, Object bean, BeanExpressionResolver beanExpressionResolver, BeanExpressionContext beanExpressionContext) {
        this.handlers = new ArrayList<InvocableHandlerMethod>(handlers);
        this.bean = bean;
        this.resolver = beanExpressionResolver;
        this.beanExpressionContext = beanExpressionContext;
    }

    public Object getBean() {
        return this.bean;
    }

    public Object invoke(Message<?> message, Object ... providedArgs) throws Exception {
        Class<?> payloadClass = message.getPayload().getClass();
        InvocableHandlerMethod handler = this.getHandlerForPayload(payloadClass);
        Object result = handler.invoke(message, providedArgs);
        Address replyTo = this.defaultReplyToForHandler.get(handler);
        if (replyTo != null) {
            defaultReplyTo.set(replyTo);
        }
        return result;
    }

    protected InvocableHandlerMethod getHandlerForPayload(Class<? extends Object> payloadClass) {
        InvocableHandlerMethod handler = (InvocableHandlerMethod)this.cachedHandlers.get(payloadClass);
        if (handler == null) {
            handler = this.findHandlerForPayload(payloadClass);
            if (handler == null) {
                throw new AmqpException("No method found for " + payloadClass);
            }
            this.cachedHandlers.putIfAbsent(payloadClass, handler);
            this.setupReplyTo(handler);
        }
        return handler;
    }

    private void setupReplyTo(InvocableHandlerMethod handler) {
        SendTo ann;
        Method method = handler.getMethod();
        if (method != null && (ann = (SendTo)AnnotationUtils.getAnnotation((Method)method, SendTo.class)) != null) {
            Address replyTo;
            Object[] destinations = ann.value();
            if (destinations.length > 1) {
                throw new IllegalStateException("Invalid @" + SendTo.class.getSimpleName() + " annotation on '" + method + "' one destination must be set (got " + Arrays.toString(destinations) + ")");
            }
            Address address = replyTo = destinations.length == 1 ? new Address(this.resolve(destinations[0])) : null;
            if (replyTo != null) {
                this.defaultReplyToForHandler.put(handler, replyTo);
            }
        }
    }

    private String resolve(String value) {
        if (this.resolver != null) {
            Object newValue = this.resolver.evaluate(value, this.beanExpressionContext);
            Assert.isInstanceOf(String.class, (Object)newValue, (String)"Invalid @SendTo expression");
            return (String)newValue;
        }
        return value;
    }

    protected InvocableHandlerMethod findHandlerForPayload(Class<? extends Object> payloadClass) {
        InvocableHandlerMethod result = null;
        for (InvocableHandlerMethod handler : this.handlers) {
            if (!this.matchHandlerMethod(payloadClass, handler)) continue;
            if (result != null) {
                throw new AmqpException("Ambiguous methods for payload type: " + payloadClass + ": " + result.getMethod().getName() + " and " + handler.getMethod().getName());
            }
            result = handler;
        }
        return result;
    }

    protected boolean matchHandlerMethod(Class<? extends Object> payloadClass, InvocableHandlerMethod handler) {
        MethodParameter methodParameter;
        Method method = handler.getMethod();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations.length == 1 && ((methodParameter = new MethodParameter(method, 0)).getParameterAnnotations().length == 0 || methodParameter.hasParameterAnnotation(Payload.class)) && methodParameter.getParameterType().isAssignableFrom(payloadClass)) {
            return true;
        }
        boolean foundCandidate = false;
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            MethodParameter methodParameter2 = new MethodParameter(method, i);
            if (methodParameter2.getParameterAnnotations().length != 0 && !methodParameter2.hasParameterAnnotation(Payload.class) || !methodParameter2.getParameterType().isAssignableFrom(payloadClass)) continue;
            if (foundCandidate) {
                throw new AmqpException("Ambiguous payload parameter for " + method.toGenericString());
            }
            foundCandidate = true;
        }
        return foundCandidate;
    }

    public String getMethodNameFor(Object payload) {
        InvocableHandlerMethod handlerForPayload = this.getHandlerForPayload(payload.getClass());
        return handlerForPayload == null ? "no match" : handlerForPayload.getMethod().toGenericString();
    }

    public Address getDefaultReplyTo() {
        Address replyTo = defaultReplyTo.get();
        if (replyTo != null) {
            defaultReplyTo.remove();
        }
        return replyTo;
    }
}

