/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.core;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Declarable;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ChannelProxy;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.core.ChannelCallback;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.util.Assert;

public class RabbitAdmin
implements AmqpAdmin,
ApplicationContextAware,
InitializingBean {
    public static final String DEFAULT_EXCHANGE_NAME = "";
    public static final Object QUEUE_NAME = "QUEUE_NAME";
    public static final Object QUEUE_MESSAGE_COUNT = "QUEUE_MESSAGE_COUNT";
    public static final Object QUEUE_CONSUMER_COUNT = "QUEUE_CONSUMER_COUNT";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final RabbitTemplate rabbitTemplate;
    private volatile boolean running = false;
    private volatile boolean autoStartup = true;
    private volatile ApplicationContext applicationContext;
    private volatile boolean ignoreDeclarationExceptions;
    private final Object lifecycleMonitor = new Object();
    private final ConnectionFactory connectionFactory;

    public RabbitAdmin(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null");
        this.rabbitTemplate = new RabbitTemplate(connectionFactory);
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setIgnoreDeclarationExceptions(boolean ignoreDeclarationExceptions) {
        this.ignoreDeclarationExceptions = ignoreDeclarationExceptions;
    }

    public RabbitTemplate getRabbitTemplate() {
        return this.rabbitTemplate;
    }

    public void declareExchange(final Exchange exchange) {
        this.rabbitTemplate.execute(new ChannelCallback<Object>(){

            @Override
            public Object doInRabbit(Channel channel) throws Exception {
                RabbitAdmin.this.declareExchanges(channel, new Exchange[]{exchange});
                return null;
            }
        });
    }

    @ManagedOperation
    public boolean deleteExchange(final String exchangeName) {
        return this.rabbitTemplate.execute(new ChannelCallback<Boolean>(){

            @Override
            public Boolean doInRabbit(Channel channel) throws Exception {
                if (RabbitAdmin.this.isDeletingDefaultExchange(exchangeName)) {
                    return true;
                }
                try {
                    channel.exchangeDelete(exchangeName);
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
        });
    }

    @ManagedOperation
    public String declareQueue(final Queue queue) {
        return this.rabbitTemplate.execute(new ChannelCallback<String>(){

            @Override
            public String doInRabbit(Channel channel) throws Exception {
                return RabbitAdmin.this.declareQueues(channel, new Queue[]{queue})[0].getQueue();
            }
        });
    }

    @ManagedOperation
    public Queue declareQueue() {
        AMQP.Queue.DeclareOk declareOk = this.rabbitTemplate.execute(new ChannelCallback<AMQP.Queue.DeclareOk>(){

            @Override
            public AMQP.Queue.DeclareOk doInRabbit(Channel channel) throws Exception {
                return channel.queueDeclare();
            }
        });
        Queue queue = new Queue(declareOk.getQueue(), false, true, true);
        return queue;
    }

    @ManagedOperation
    public boolean deleteQueue(final String queueName) {
        return this.rabbitTemplate.execute(new ChannelCallback<Boolean>(){

            @Override
            public Boolean doInRabbit(Channel channel) throws Exception {
                try {
                    channel.queueDelete(queueName);
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
        });
    }

    @ManagedOperation
    public void deleteQueue(final String queueName, final boolean unused, final boolean empty) {
        this.rabbitTemplate.execute(new ChannelCallback<Object>(){

            @Override
            public Object doInRabbit(Channel channel) throws Exception {
                channel.queueDelete(queueName, unused, empty);
                return null;
            }
        });
    }

    @ManagedOperation
    public void purgeQueue(final String queueName, boolean noWait) {
        this.rabbitTemplate.execute(new ChannelCallback<Object>(){

            @Override
            public Object doInRabbit(Channel channel) throws Exception {
                channel.queuePurge(queueName);
                return null;
            }
        });
    }

    @ManagedOperation
    public void declareBinding(final Binding binding) {
        this.rabbitTemplate.execute(new ChannelCallback<Object>(){

            @Override
            public Object doInRabbit(Channel channel) throws Exception {
                RabbitAdmin.this.declareBindings(channel, new Binding[]{binding});
                return null;
            }
        });
    }

    @ManagedOperation
    public void removeBinding(final Binding binding) {
        this.rabbitTemplate.execute(new ChannelCallback<Object>(){

            @Override
            public Object doInRabbit(Channel channel) throws Exception {
                if (binding.isDestinationQueue()) {
                    if (RabbitAdmin.this.isRemovingImplicitQueueBinding(binding)) {
                        return null;
                    }
                    channel.queueUnbind(binding.getDestination(), binding.getExchange(), binding.getRoutingKey(), binding.getArguments());
                } else {
                    channel.exchangeUnbind(binding.getDestination(), binding.getExchange(), binding.getRoutingKey(), binding.getArguments());
                }
                return null;
            }
        });
    }

    public Properties getQueueProperties(final String queueName) {
        Assert.hasText((String)queueName, (String)"'queueName' cannot be null or empty");
        return this.rabbitTemplate.execute(new ChannelCallback<Properties>(){

            @Override
            public Properties doInRabbit(Channel channel) throws Exception {
                try {
                    AMQP.Queue.DeclareOk declareOk = channel.queueDeclarePassive(queueName);
                    Properties props = new Properties();
                    props.put(QUEUE_NAME, declareOk.getQueue());
                    props.put(QUEUE_MESSAGE_COUNT, (Object)declareOk.getMessageCount());
                    props.put(QUEUE_CONSUMER_COUNT, (Object)declareOk.getConsumerCount());
                    return props;
                }
                catch (IllegalArgumentException e) {
                    try {
                        if (channel instanceof ChannelProxy) {
                            ((ChannelProxy)channel).getTargetChannel().close();
                        }
                    }
                    catch (TimeoutException timeoutException) {
                        // empty catch block
                    }
                    return null;
                }
                catch (Exception e) {
                    if (RabbitAdmin.this.logger.isDebugEnabled()) {
                        RabbitAdmin.this.logger.debug((Object)("Queue '" + queueName + "' does not exist"));
                    }
                    return null;
                }
            }
        });
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.running || !this.autoStartup) {
                return;
            }
            if (this.connectionFactory instanceof CachingConnectionFactory && ((CachingConnectionFactory)this.connectionFactory).getCacheMode() == CachingConnectionFactory.CacheMode.CONNECTION) {
                this.logger.warn((Object)"RabbitAdmin auto declaration is not supported with CacheMode.CONNECTION");
                return;
            }
            this.connectionFactory.addConnectionListener(new ConnectionListener(){
                private final AtomicBoolean initializing = new AtomicBoolean(false);

                @Override
                public void onCreate(Connection connection) {
                    if (!this.initializing.compareAndSet(false, true)) {
                        return;
                    }
                    try {
                        RabbitAdmin.this.initialize();
                    }
                    finally {
                        this.initializing.compareAndSet(true, false);
                    }
                }

                @Override
                public void onClose(Connection connection) {
                }
            });
            this.running = true;
        }
    }

    public void initialize() {
        if (this.applicationContext == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"no ApplicationContext has been set, cannot auto-declare Exchanges, Queues, and Bindings");
            }
            return;
        }
        this.logger.debug((Object)"Initializing declarations");
        LinkedList contextExchanges = new LinkedList(this.applicationContext.getBeansOfType(Exchange.class).values());
        LinkedList contextQueues = new LinkedList(this.applicationContext.getBeansOfType(Queue.class).values());
        LinkedList contextBindings = new LinkedList(this.applicationContext.getBeansOfType(Binding.class).values());
        Collection collections = this.applicationContext.getBeansOfType(Collection.class).values();
        for (Collection collection : collections) {
            if (collection.size() <= 0 || !(collection.iterator().next() instanceof Declarable)) continue;
            for (Object declarable : collection) {
                if (declarable instanceof Exchange) {
                    contextExchanges.add((Exchange)declarable);
                    continue;
                }
                if (declarable instanceof Queue) {
                    contextQueues.add((Queue)declarable);
                    continue;
                }
                if (!(declarable instanceof Binding)) continue;
                contextBindings.add((Binding)declarable);
            }
        }
        final Collection exchanges = this.filterDeclarables(contextExchanges);
        final Collection queues = this.filterDeclarables(contextQueues);
        final Collection bindings = this.filterDeclarables(contextBindings);
        for (Exchange exchange : exchanges) {
            if (exchange.isDurable() && !exchange.isAutoDelete()) continue;
            this.logger.info((Object)("Auto-declaring a non-durable or auto-delete Exchange (" + exchange.getName() + ") durable:" + exchange.isDurable() + ", auto-delete:" + exchange.isAutoDelete() + ". " + "It will be deleted by the broker if it shuts down, and can be redeclared by closing and " + "reopening the connection."));
        }
        for (Queue queue : queues) {
            if (queue.isDurable() && !queue.isAutoDelete() && !queue.isExclusive()) continue;
            this.logger.info((Object)("Auto-declaring a non-durable, auto-delete, or exclusive Queue (" + queue.getName() + ") durable:" + queue.isDurable() + ", auto-delete:" + queue.isAutoDelete() + ", exclusive:" + queue.isExclusive() + ". " + "It will be redeclared if the broker stops and is restarted while the connection factory is " + "alive, but all messages will be lost."));
        }
        this.rabbitTemplate.execute(new ChannelCallback<Object>(){

            @Override
            public Object doInRabbit(Channel channel) throws Exception {
                RabbitAdmin.this.declareExchanges(channel, exchanges.toArray(new Exchange[exchanges.size()]));
                RabbitAdmin.this.declareQueues(channel, queues.toArray(new Queue[queues.size()]));
                RabbitAdmin.this.declareBindings(channel, bindings.toArray(new Binding[bindings.size()]));
                return null;
            }
        });
        this.logger.debug((Object)"Declarations finished");
    }

    private <T extends Declarable> Collection<T> filterDeclarables(Collection<T> declarables) {
        ArrayList<Declarable> filtered = new ArrayList<Declarable>();
        for (Declarable declarable : declarables) {
            Collection adminsWithWhichToDeclare = declarable.getDeclaringAdmins();
            if (!declarable.shouldDeclare() || !adminsWithWhichToDeclare.isEmpty() && !adminsWithWhichToDeclare.contains(this)) continue;
            filtered.add(declarable);
        }
        return filtered;
    }

    private void declareExchanges(Channel channel, Exchange ... exchanges) throws IOException {
        for (Exchange exchange : exchanges) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("declaring Exchange '" + exchange.getName() + "'"));
            }
            if (this.isDeclaringDefaultExchange(exchange)) continue;
            try {
                channel.exchangeDeclare(exchange.getName(), exchange.getType(), exchange.isDurable(), exchange.isAutoDelete(), exchange.getArguments());
            }
            catch (IOException e) {
                if (this.ignoreDeclarationExceptions) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn((Object)("Failed to declare exchange:" + exchange + ", continuing..."), (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
    }

    private AMQP.Queue.DeclareOk[] declareQueues(Channel channel, Queue ... queues) throws IOException {
        AMQP.Queue.DeclareOk[] declareOks = new AMQP.Queue.DeclareOk[queues.length];
        for (int i = 0; i < queues.length; ++i) {
            Queue queue = queues[i];
            if (!queue.getName().startsWith("amq.")) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("declaring Queue '" + queue.getName() + "'"));
                }
                try {
                    try {
                        AMQP.Queue.DeclareOk declareOk;
                        declareOks[i] = declareOk = channel.queueDeclare(queue.getName(), queue.isDurable(), queue.isExclusive(), queue.isAutoDelete(), queue.getArguments());
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        try {
                            if (channel instanceof ChannelProxy) {
                                ((ChannelProxy)channel).getTargetChannel().close();
                            }
                        }
                        catch (TimeoutException timeoutException) {
                            // empty catch block
                        }
                        throw new IOException(e);
                    }
                }
                catch (IOException e) {
                    if (this.ignoreDeclarationExceptions) {
                        if (!this.logger.isWarnEnabled()) continue;
                        this.logger.warn((Object)("Failed to declare queue:" + queue + ", continuing..."), (Throwable)e);
                        continue;
                    }
                    throw e;
                }
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)"Queue with name that starts with 'amq.' cannot be declared.");
        }
        return declareOks;
    }

    private void declareBindings(Channel channel, Binding ... bindings) throws IOException {
        for (Binding binding : bindings) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Binding destination [" + binding.getDestination() + " (" + binding.getDestinationType() + ")] to exchange [" + binding.getExchange() + "] with routing key [" + binding.getRoutingKey() + "]"));
            }
            try {
                if (binding.isDestinationQueue()) {
                    if (this.isDeclaringImplicitQueueBinding(binding)) continue;
                    channel.queueBind(binding.getDestination(), binding.getExchange(), binding.getRoutingKey(), binding.getArguments());
                    continue;
                }
                channel.exchangeBind(binding.getDestination(), binding.getExchange(), binding.getRoutingKey(), binding.getArguments());
            }
            catch (IOException e) {
                if (this.ignoreDeclarationExceptions) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn((Object)("Failed to declare binding:" + binding + ", continuing..."), (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
    }

    private boolean isDeclaringDefaultExchange(Exchange exchange) {
        if (this.isDefaultExchange(exchange.getName())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Default exchange is pre-declared by server.");
            }
            return true;
        }
        return false;
    }

    private boolean isDeletingDefaultExchange(String exchangeName) {
        if (this.isDefaultExchange(exchangeName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Default exchange cannot be deleted.");
            }
            return true;
        }
        return false;
    }

    private boolean isDefaultExchange(String exchangeName) {
        return DEFAULT_EXCHANGE_NAME.equals(exchangeName);
    }

    private boolean isDeclaringImplicitQueueBinding(Binding binding) {
        if (this.isImplicitQueueBinding(binding)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"The default exchange is implicitly bound to every queue, with a routing key equal to the queue name.");
            }
            return true;
        }
        return false;
    }

    private boolean isRemovingImplicitQueueBinding(Binding binding) {
        if (this.isImplicitQueueBinding(binding)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Cannot remove implicit default exchange binding to queue.");
            }
            return true;
        }
        return false;
    }

    private boolean isImplicitQueueBinding(Binding binding) {
        return this.isDefaultExchange(binding.getExchange()) && binding.getDestination().equals(binding.getRoutingKey());
    }
}

