/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.util.Assert;

public abstract class RabbitUtils {
    public static final int DEFAULT_PORT = 5672;
    private static final Log logger = LogFactory.getLog(RabbitUtils.class);
    private static final ThreadLocal<Boolean> physicalCloseRequired = new ThreadLocal();

    public static void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception ex) {
                logger.debug((Object)("Ignoring Connection exception - assuming already closed: " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public static void closeChannel(Channel channel) {
        if (channel != null && channel.isOpen()) {
            try {
                channel.close();
            }
            catch (IOException ex) {
                logger.debug((Object)"Could not close RabbitMQ Channel", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.debug((Object)"Unexpected exception on closing RabbitMQ Channel", ex);
            }
        }
    }

    public static void commitIfNecessary(Channel channel) {
        Assert.notNull((Object)channel, (String)"Channel must not be null");
        try {
            channel.txCommit();
        }
        catch (IOException ex) {
            throw new AmqpIOException(ex);
        }
    }

    public static void rollbackIfNecessary(Channel channel) {
        Assert.notNull((Object)channel, (String)"Channel must not be null");
        try {
            channel.txRollback();
        }
        catch (IOException ex) {
            throw new AmqpIOException(ex);
        }
    }

    public static void closeMessageConsumer(Channel channel, String consumerTag, boolean transactional) {
        if (!channel.isOpen()) {
            return;
        }
        try {
            channel.basicCancel(consumerTag);
            if (transactional) {
                channel.basicRecover(true);
            }
        }
        catch (Exception ex) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(ex);
        }
    }

    public static void declareTransactional(Channel channel) {
        try {
            channel.txSelect();
        }
        catch (IOException e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    public static void setPhysicalCloseRequired(boolean b) {
        physicalCloseRequired.set(b);
    }

    public static boolean isPhysicalCloseRequired() {
        Boolean mustClose = physicalCloseRequired.get();
        if (mustClose == null) {
            mustClose = Boolean.FALSE;
        } else {
            physicalCloseRequired.remove();
        }
        return mustClose;
    }
}

