/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.test.mockito;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;
import org.mockito.internal.stubbing.defaultanswers.ForwardsInvocations;
import org.mockito.invocation.InvocationOnMock;

public class LatchCountDownAndCallRealMethodAnswer
extends ForwardsInvocations {
    private static final long serialVersionUID = 1L;
    private final transient CountDownLatch latch;
    private final transient Set<Exception> exceptions = ConcurrentHashMap.newKeySet();
    private final boolean hasDelegate;

    public LatchCountDownAndCallRealMethodAnswer(int count, @Nullable Object delegate) {
        super(delegate);
        this.latch = new CountDownLatch(count);
        this.hasDelegate = delegate != null;
    }

    public @Nullable Object answer(InvocationOnMock invocation) throws Throwable {
        try {
            if (this.hasDelegate) {
                Object object = super.answer(invocation);
                return object;
            }
            invocation.callRealMethod();
        }
        catch (Exception e) {
            this.exceptions.add(e);
            throw e;
        }
        finally {
            this.latch.countDown();
        }
        return null;
    }

    public boolean await(int timeout) throws InterruptedException {
        return this.latch.await(timeout, TimeUnit.SECONDS);
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public @Nullable Collection<Exception> getExceptions() {
        return new LinkedHashSet<Exception>(this.exceptions);
    }
}

