/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rabbit.stream.listener.adapter;

import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.MessageHandler;
import java.lang.reflect.Method;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.rabbit.listener.adapter.InvocationResult;
import org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.amqp.rabbit.listener.api.RabbitListenerErrorHandler;
import org.springframework.amqp.rabbit.support.ListenerExecutionFailedException;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.rabbit.stream.listener.StreamMessageListener;

public class StreamMessageListenerAdapter
extends MessagingMessageListenerAdapter
implements StreamMessageListener {
    private static final GenericMessage<?> FAKE_MESSAGE = new GenericMessage((Object)"");

    public StreamMessageListenerAdapter(@Nullable Object bean, @Nullable Method method, boolean returnExceptions, @Nullable RabbitListenerErrorHandler errorHandler) {
        super(bean, method, returnExceptions, errorHandler);
    }

    @Override
    public void onStreamMessage(Message message, MessageHandler.Context context) {
        try {
            InvocationResult result = this.getHandlerAdapter().invoke(FAKE_MESSAGE, new Object[]{message, context});
            if (result.getReturnValue() != null) {
                this.logger.warn((Object)"Replies are not currently supported with native Stream listeners");
            } else {
                this.logger.trace((Object)"No result object given - no result to handle");
            }
        }
        catch (Exception ex) {
            throw new ListenerExecutionFailedException("Failed to invoke listener", (Throwable)ex, new org.springframework.amqp.core.Message[0]);
        }
    }
}

