/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rabbit.stream.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Declarable;
import org.springframework.amqp.core.Declarables;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.util.Assert;

public class SuperStream
extends Declarables {
    public SuperStream(String name, int partitions) {
        this(name, partitions, Map.of());
    }

    public SuperStream(String name, int partitions, Map<String, Object> arguments) {
        this(name, partitions, (q, i) -> IntStream.range(0, i).mapToObj(String::valueOf).collect(Collectors.toList()), arguments);
    }

    public SuperStream(String name, int partitions, BiFunction<String, Integer, List<String>> routingKeyStrategy) {
        this(name, partitions, routingKeyStrategy, Map.of());
    }

    public SuperStream(String name, int partitions, BiFunction<String, Integer, List<String>> routingKeyStrategy, Map<String, Object> arguments) {
        super(SuperStream.declarables(name, partitions, routingKeyStrategy, arguments));
    }

    private static Collection<Declarable> declarables(String name, int partitions, BiFunction<String, Integer, List<String>> routingKeyStrategy, Map<String, Object> arguments) {
        List<String> rks = routingKeyStrategy.apply(name, partitions);
        Assert.state((rks.size() == partitions ? 1 : 0) != 0, () -> "Expected " + partitions + " routing keys, not " + rks.size());
        ArrayList<Declarable> declarables = new ArrayList<Declarable>(partitions + 1);
        declarables.add((Declarable)new DirectExchange(name, true, false, Map.of("x-super-stream", true)));
        HashMap<String, @Nullable Object> argumentsCopy = new HashMap<String, Object>(arguments);
        argumentsCopy.put("x-queue-type", "stream");
        for (int i = 0; i < partitions; ++i) {
            String rk = rks.get(i);
            Queue q = new Queue(name + "-" + i, true, false, false, argumentsCopy);
            declarables.add((Declarable)q);
            declarables.add((Declarable)new Binding(q.getName(), Binding.DestinationType.QUEUE, name, rk, Map.of("x-stream-partition-order", i)));
        }
        return declarables;
    }
}

