/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.junit;

import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.amqp.rabbit.junit.LongRunning;
import org.springframework.amqp.rabbit.junit.LongRunningIntegrationTest;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class LongRunningIntegrationTestCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"@LongRunning is not present");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional element = context.getElement();
        LongRunning longRunning = (LongRunning)AnnotationUtils.findAnnotation((AnnotatedElement)((AnnotatedElement)element.get()), LongRunning.class);
        if (longRunning != null) {
            LongRunningIntegrationTest lrit;
            String property = longRunning.value();
            if (!StringUtils.hasText((String)property)) {
                property = "RUN_LONG_INTEGRATION_TESTS";
            }
            return (lrit = new LongRunningIntegrationTest(property)).isShouldRun() ? ConditionEvaluationResult.enabled((String)"Long running tests must run") : ConditionEvaluationResult.disabled((String)"Long running tests are skipped");
        }
        return ENABLED;
    }
}

