/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.testcontainers.service.connection.mongo;

import com.mongodb.ConnectionString;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.springframework.boot.mongodb.autoconfigure.MongoConnectionDetails;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.springframework.util.ReflectionUtils;
import org.testcontainers.mongodb.MongoDBAtlasLocalContainer;

class MongoDbAtlasLocalContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<MongoDBAtlasLocalContainer, MongoConnectionDetails> {
    private static final Method GET_SSL_BUNDLE_METHOD = ReflectionUtils.findMethod(MongoConnectionDetails.class, (String)"getSslBundle");

    MongoDbAtlasLocalContainerConnectionDetailsFactory() {
    }

    protected MongoConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<MongoDBAtlasLocalContainer> source) {
        return new MongoDbAtlasLocalContainerConnectionDetails(source);
    }

    private static final class MongoDbAtlasLocalContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<MongoDBAtlasLocalContainer>
    implements MongoConnectionDetails {
        private MongoDbAtlasLocalContainerConnectionDetails(ContainerConnectionSource<MongoDBAtlasLocalContainer> source) {
            super(source);
        }

        public ConnectionString getConnectionString() {
            return new ConnectionString(((MongoDBAtlasLocalContainer)this.getContainer()).getConnectionString());
        }

        public SslBundle getSslBundle() {
            if (GET_SSL_BUNDLE_METHOD != null) {
                try {
                    MethodHandles.Lookup origin = MethodHandles.lookup().in(((Object)((Object)this)).getClass());
                    return (SslBundle)MethodHandles.privateLookupIn(GET_SSL_BUNDLE_METHOD.getDeclaringClass(), origin).unreflectSpecial(GET_SSL_BUNDLE_METHOD, GET_SSL_BUNDLE_METHOD.getDeclaringClass()).bindTo((Object)this).invokeWithArguments(new Object[0]);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
    }
}

