/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.tool.augment;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.ai.util.json.JsonParser;

public final class ToolInputSchemaAugmenter {
    private ToolInputSchemaAugmenter() {
    }

    public static <T extends Record> List<AugmentedArgumentType> toAugmentedArgumentTypes(Class<T> recordClass) {
        try {
            return Arrays.stream(recordClass.getRecordComponents()).map(c -> {
                ToolParam toolParam = null;
                try {
                    Field field = recordClass.getDeclaredField(c.getName());
                    toolParam = field.getAnnotation(ToolParam.class);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                return new AugmentedArgumentType(c.getName(), c.getGenericType(), toolParam != null ? toolParam.description() : "no description", toolParam != null ? toolParam.required() : false);
            }).toList();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to extract record field types", e);
        }
    }

    public static String augmentToolInputSchema(String jsonSchemaString, String propertyName, Type propertyType, String description, boolean required) {
        return ToolInputSchemaAugmenter.augmentToolInputSchema(jsonSchemaString, List.of(new AugmentedArgumentType(propertyName, propertyType, description, required)));
    }

    public static String augmentToolInputSchema(String jsonSchemaString, List<AugmentedArgumentType> argumentType) {
        try {
            ObjectNode propertiesNode;
            ObjectNode schemaObjectNode = (ObjectNode)ModelOptionsUtils.OBJECT_MAPPER.readTree(jsonSchemaString);
            if (schemaObjectNode.has("properties")) {
                propertiesNode = (ObjectNode)schemaObjectNode.get("properties");
            } else {
                propertiesNode = ModelOptionsUtils.OBJECT_MAPPER.createObjectNode();
                schemaObjectNode.set("properties", (JsonNode)propertiesNode);
            }
            for (AugmentedArgumentType argument : argumentType) {
                ArrayNode requiredArray;
                ObjectNode parameterNode = ModelOptionsUtils.getJsonSchema(argument.type());
                if (argument.description() != null && !argument.description().isEmpty()) {
                    parameterNode.put("description", argument.description());
                }
                propertiesNode.set(argument.name(), (JsonNode)parameterNode);
                if (!argument.required()) continue;
                if (schemaObjectNode.has("required")) {
                    requiredArray = (ArrayNode)schemaObjectNode.get("required");
                } else {
                    requiredArray = JsonParser.getObjectMapper().createArrayNode();
                    schemaObjectNode.set("required", (JsonNode)requiredArray);
                }
                requiredArray.add(argument.name());
            }
            return JsonParser.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)schemaObjectNode);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse JSON Schema", e);
        }
    }

    public record AugmentedArgumentType(String name, Type type, String description, boolean required) {
    }
}

