/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.moderation;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.moderation.Categories;
import org.springframework.ai.moderation.CategoryScores;

public final class ModerationResult {
    private boolean flagged;
    private @Nullable Categories categories;
    private @Nullable CategoryScores categoryScores;

    private ModerationResult(Builder builder) {
        this.flagged = builder.flagged;
        this.categories = builder.categories;
        this.categoryScores = builder.categoryScores;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isFlagged() {
        return this.flagged;
    }

    public void setFlagged(boolean flagged) {
        this.flagged = flagged;
    }

    public @Nullable Categories getCategories() {
        return this.categories;
    }

    public void setCategories(Categories categories) {
        this.categories = categories;
    }

    public @Nullable CategoryScores getCategoryScores() {
        return this.categoryScores;
    }

    public void setCategoryScores(CategoryScores categoryScores) {
        this.categoryScores = categoryScores;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModerationResult)) {
            return false;
        }
        ModerationResult that = (ModerationResult)o;
        return this.flagged == that.flagged && Objects.equals(this.categories, that.categories) && Objects.equals(this.categoryScores, that.categoryScores);
    }

    public int hashCode() {
        return Objects.hash(this.flagged, this.categories, this.categoryScores);
    }

    public String toString() {
        return "ModerationResult{flagged=" + this.flagged + ", categories=" + String.valueOf(this.categories) + ", categoryScores=" + String.valueOf(this.categoryScores) + "}";
    }

    public static final class Builder {
        private boolean flagged;
        private @Nullable Categories categories;
        private @Nullable CategoryScores categoryScores;

        public Builder flagged(boolean flagged) {
            this.flagged = flagged;
            return this;
        }

        public Builder categories(Categories categories) {
            this.categories = categories;
            return this;
        }

        public Builder categoryScores(CategoryScores categoryScores) {
            this.categoryScores = categoryScores;
            return this;
        }

        public ModerationResult build() {
            return new ModerationResult(this);
        }
    }
}

