/*
 * Copyright 2023-2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Provides a set of interfaces and classes for a generic API designed to interact with
 * various AI models. This package includes interfaces for handling AI model calls,
 * requests, responses, results, and associated metadata. It is designed to offer a
 * flexible and adaptable framework for interacting with different types of AI models,
 * abstracting the complexities involved in model invocation and result processing. The
 * use of generics enhances the API's capability to work with a wide range of models,
 * ensuring a broad applicability across diverse AI scenarios.
 *
 */

@NullMarked
package org.springframework.ai.model;

import org.jspecify.annotations.NullMarked;
