/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.reader.markdown;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.Code;
import org.commonmark.node.Document;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import org.commonmark.node.Visitor;
import org.commonmark.parser.Parser;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentReader;
import org.springframework.ai.reader.markdown.config.MarkdownDocumentReaderConfig;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class MarkdownDocumentReader
implements DocumentReader {
    private final Resource[] markdownResources;
    private final MarkdownDocumentReaderConfig config;
    private final Parser parser;

    public MarkdownDocumentReader(String markdownResources) {
        this(markdownResources, MarkdownDocumentReaderConfig.defaultConfig());
    }

    public MarkdownDocumentReader(String markdownResources, MarkdownDocumentReaderConfig config) {
        this(MarkdownDocumentReader.resolveResources(markdownResources), config);
    }

    public MarkdownDocumentReader(Resource markdownResource, MarkdownDocumentReaderConfig config) {
        this(List.of(markdownResource), config);
    }

    public MarkdownDocumentReader(List<Resource> markdownResources, MarkdownDocumentReaderConfig config) {
        this.markdownResources = markdownResources.toArray(new Resource[0]);
        this.config = config;
        this.parser = Parser.builder().build();
    }

    private static List<Resource> resolveResources(String markdownResources) {
        try {
            return List.of(new PathMatchingResourcePatternResolver().getResources(markdownResources));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<org.springframework.ai.document.Document> get() {
        ArrayList<org.springframework.ai.document.Document> documents = new ArrayList<org.springframework.ai.document.Document>();
        for (Resource markdownResource : this.markdownResources) {
            DocumentVisitor documentVisitor = new DocumentVisitor(this.config);
            try (InputStream input = markdownResource.getInputStream();){
                Node node = this.parser.parseReader((Reader)new InputStreamReader(input));
                node.accept((Visitor)documentVisitor);
                documents.addAll(documentVisitor.getDocuments());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return documents;
    }

    static class DocumentVisitor
    extends AbstractVisitor {
        private final List<org.springframework.ai.document.Document> documents = new ArrayList<org.springframework.ai.document.Document>();
        private final List<String> currentParagraphs = new ArrayList<String>();
        private final MarkdownDocumentReaderConfig config;
        private Document.Builder currentDocumentBuilder;

        DocumentVisitor(MarkdownDocumentReaderConfig config) {
            this.config = config;
        }

        public void visit(Document document) {
            this.currentDocumentBuilder = org.springframework.ai.document.Document.builder();
            super.visit(document);
        }

        public void visit(Heading heading) {
            this.buildAndFlush();
            super.visit(heading);
        }

        public void visit(ThematicBreak thematicBreak) {
            if (this.config.horizontalRuleCreateDocument) {
                this.buildAndFlush();
            }
            super.visit(thematicBreak);
        }

        public void visit(SoftLineBreak softLineBreak) {
            this.translateLineBreakToSpace();
            super.visit(softLineBreak);
        }

        public void visit(HardLineBreak hardLineBreak) {
            this.translateLineBreakToSpace();
            super.visit(hardLineBreak);
        }

        public void visit(ListItem listItem) {
            this.translateLineBreakToSpace();
            super.visit(listItem);
        }

        public void visit(BlockQuote blockQuote) {
            if (!this.config.includeBlockquote) {
                this.buildAndFlush();
            }
            this.translateLineBreakToSpace();
            this.currentDocumentBuilder.metadata("category", (Object)"blockquote");
            super.visit(blockQuote);
        }

        public void visit(Code code) {
            this.currentParagraphs.add(code.getLiteral());
            this.currentDocumentBuilder.metadata("category", (Object)"code_inline");
            super.visit(code);
        }

        public void visit(FencedCodeBlock fencedCodeBlock) {
            if (!this.config.includeCodeBlock) {
                this.buildAndFlush();
            }
            this.translateLineBreakToSpace();
            this.currentParagraphs.add(fencedCodeBlock.getLiteral());
            this.currentDocumentBuilder.metadata("category", (Object)"code_block");
            this.currentDocumentBuilder.metadata("lang", (Object)fencedCodeBlock.getInfo());
            this.buildAndFlush();
            super.visit(fencedCodeBlock);
        }

        public void visit(Text text) {
            Node node = text.getParent();
            if (node instanceof Heading) {
                Heading heading = (Heading)node;
                this.currentDocumentBuilder.metadata("category", (Object)"header_%d".formatted(heading.getLevel())).metadata("title", (Object)text.getLiteral());
            } else {
                this.currentParagraphs.add(text.getLiteral());
            }
            super.visit(text);
        }

        public List<org.springframework.ai.document.Document> getDocuments() {
            this.buildAndFlush();
            return this.documents;
        }

        private void buildAndFlush() {
            if (!this.currentParagraphs.isEmpty()) {
                String content = String.join((CharSequence)"", this.currentParagraphs);
                Document.Builder builder = this.currentDocumentBuilder.text(content);
                this.config.additionalMetadata.forEach((arg_0, arg_1) -> ((Document.Builder)builder).metadata(arg_0, arg_1));
                org.springframework.ai.document.Document document = builder.build();
                this.documents.add(document);
                this.currentParagraphs.clear();
            }
            this.currentDocumentBuilder = org.springframework.ai.document.Document.builder();
        }

        private void translateLineBreakToSpace() {
            if (!this.currentParagraphs.isEmpty()) {
                this.currentParagraphs.add(" ");
            }
        }
    }
}

