/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.observation;

import io.micrometer.observation.Observation;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.chat.client.ChatClientAttributes;
import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.observation.AiOperationMetadata;
import org.springframework.ai.observation.conventions.AiOperationType;
import org.springframework.ai.observation.conventions.AiProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ChatClientObservationContext
extends Observation.Context {
    private final ChatClientRequest request;
    private @Nullable ChatClientResponse response;
    private final AiOperationMetadata operationMetadata = new AiOperationMetadata(AiOperationType.FRAMEWORK.value(), AiProvider.SPRING_AI.value());
    private final List<? extends Advisor> advisors;
    private final boolean stream;

    ChatClientObservationContext(ChatClientRequest chatClientRequest, List<? extends Advisor> advisors, boolean isStream) {
        Assert.notNull((Object)chatClientRequest, (String)"chatClientRequest cannot be null");
        Assert.notNull(advisors, (String)"advisors cannot be null");
        Assert.noNullElements(advisors, (String)"advisors cannot contain null elements");
        this.request = chatClientRequest;
        this.advisors = advisors;
        this.stream = isStream;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ChatClientRequest getRequest() {
        return this.request;
    }

    public AiOperationMetadata getOperationMetadata() {
        return this.operationMetadata;
    }

    public List<? extends Advisor> getAdvisors() {
        return this.advisors;
    }

    public boolean isStream() {
        return this.stream;
    }

    public @Nullable String getFormat() {
        Object object = this.request.context().get(ChatClientAttributes.OUTPUT_FORMAT.getKey());
        if (object instanceof String) {
            String format = (String)object;
            return format;
        }
        return null;
    }

    public @Nullable ChatClientResponse getResponse() {
        return this.response;
    }

    public void setResponse(ChatClientResponse response) {
        this.response = response;
    }

    public static final class Builder {
        private @Nullable ChatClientRequest chatClientRequest;
        private List<? extends Advisor> advisors = List.of();
        private @Nullable String format;
        private boolean isStream = false;

        private Builder() {
        }

        public Builder request(ChatClientRequest chatClientRequest) {
            this.chatClientRequest = chatClientRequest;
            return this;
        }

        public Builder format(@Nullable String format) {
            this.format = format;
            return this;
        }

        public Builder advisors(List<? extends Advisor> advisors) {
            this.advisors = advisors;
            return this;
        }

        public Builder stream(boolean isStream) {
            this.isStream = isStream;
            return this;
        }

        public ChatClientObservationContext build() {
            Assert.state((this.chatClientRequest != null ? 1 : 0) != 0, (String)"chatClientRequest cannot be null");
            if (StringUtils.hasText((String)this.format)) {
                this.chatClientRequest.context().put(ChatClientAttributes.OUTPUT_FORMAT.getKey(), this.format);
            }
            return new ChatClientObservationContext(this.chatClientRequest, this.advisors, this.isStream);
        }
    }
}

