/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.client.ChatClientAttributes;
import org.springframework.ai.chat.client.ChatClientMessageAggregator;
import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.client.DefaultChatClientBuilder;
import org.springframework.ai.chat.client.DefaultChatClientUtils;
import org.springframework.ai.chat.client.ResponseEntity;
import org.springframework.ai.chat.client.advisor.ChatModelCallAdvisor;
import org.springframework.ai.chat.client.advisor.ChatModelStreamAdvisor;
import org.springframework.ai.chat.client.advisor.DefaultAroundAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.client.advisor.api.BaseAdvisorChain;
import org.springframework.ai.chat.client.advisor.observation.AdvisorObservationConvention;
import org.springframework.ai.chat.client.observation.ChatClientObservationContext;
import org.springframework.ai.chat.client.observation.ChatClientObservationConvention;
import org.springframework.ai.chat.client.observation.ChatClientObservationDocumentation;
import org.springframework.ai.chat.client.observation.DefaultChatClientObservationConvention;
import org.springframework.ai.chat.messages.AbstractMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.content.Media;
import org.springframework.ai.converter.BeanOutputConverter;
import org.springframework.ai.converter.StructuredOutputConverter;
import org.springframework.ai.support.ToolCallbacks;
import org.springframework.ai.template.TemplateRenderer;
import org.springframework.ai.template.st.StTemplateRenderer;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public class DefaultChatClient
implements ChatClient {
    private static final ChatClientObservationConvention DEFAULT_CHAT_CLIENT_OBSERVATION_CONVENTION = new DefaultChatClientObservationConvention();
    private static final TemplateRenderer DEFAULT_TEMPLATE_RENDERER = StTemplateRenderer.builder().build();
    private static final ChatClientMessageAggregator CHAT_CLIENT_MESSAGE_AGGREGATOR = new ChatClientMessageAggregator();
    private final DefaultChatClientRequestSpec defaultChatClientRequest;

    public DefaultChatClient(DefaultChatClientRequestSpec defaultChatClientRequest) {
        Assert.notNull((Object)defaultChatClientRequest, (String)"defaultChatClientRequest cannot be null");
        this.defaultChatClientRequest = defaultChatClientRequest;
    }

    @Override
    public ChatClient.ChatClientRequestSpec prompt() {
        return new DefaultChatClientRequestSpec(this.defaultChatClientRequest);
    }

    @Override
    public ChatClient.ChatClientRequestSpec prompt(String content) {
        Assert.hasText((String)content, (String)"content cannot be null or empty");
        return this.prompt(new Prompt(content));
    }

    @Override
    public ChatClient.ChatClientRequestSpec prompt(Prompt prompt) {
        Assert.notNull((Object)prompt, (String)"prompt cannot be null");
        DefaultChatClientRequestSpec spec = new DefaultChatClientRequestSpec(this.defaultChatClientRequest);
        if (prompt.getOptions() != null) {
            spec.options(prompt.getOptions());
        }
        if (prompt.getInstructions() != null) {
            spec.messages(prompt.getInstructions());
        }
        return spec;
    }

    @Override
    public ChatClient.Builder mutate() {
        return this.defaultChatClientRequest.mutate();
    }

    public static class DefaultChatClientRequestSpec
    implements ChatClient.ChatClientRequestSpec {
        private final ObservationRegistry observationRegistry;
        private final ChatClientObservationConvention chatClientObservationConvention;
        private final @Nullable AdvisorObservationConvention advisorObservationConvention;
        private final ChatModel chatModel;
        private final List<Media> media = new ArrayList<Media>();
        private final List<String> toolNames = new ArrayList<String>();
        private final List<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
        private final List<ToolCallbackProvider> toolCallbackProviders = new ArrayList<ToolCallbackProvider>();
        private final List<Message> messages = new ArrayList<Message>();
        private final Map<String, Object> userParams = new HashMap<String, Object>();
        private final Map<String, Object> userMetadata = new HashMap<String, Object>();
        private final Map<String, Object> systemParams = new HashMap<String, Object>();
        private final Map<String, Object> systemMetadata = new HashMap<String, Object>();
        private final List<Advisor> advisors = new ArrayList<Advisor>();
        private final Map<String, Object> advisorParams = new HashMap<String, Object>();
        private final Map<String, Object> toolContext = new HashMap<String, Object>();
        private TemplateRenderer templateRenderer;
        private @Nullable String userText;
        private @Nullable String systemText;
        private @Nullable ChatOptions chatOptions;

        DefaultChatClientRequestSpec(DefaultChatClientRequestSpec ccr) {
            this(ccr.chatModel, ccr.userText, ccr.userParams, ccr.userMetadata, ccr.systemText, ccr.systemParams, ccr.systemMetadata, ccr.toolCallbacks, ccr.toolCallbackProviders, ccr.messages, ccr.toolNames, ccr.media, ccr.chatOptions, ccr.advisors, ccr.advisorParams, ccr.observationRegistry, ccr.chatClientObservationConvention, ccr.toolContext, ccr.templateRenderer, ccr.advisorObservationConvention);
        }

        public DefaultChatClientRequestSpec(ChatModel chatModel, @Nullable String userText, Map<String, Object> userParams, Map<String, Object> userMetadata, @Nullable String systemText, Map<String, Object> systemParams, Map<String, Object> systemMetadata, List<ToolCallback> toolCallbacks, List<ToolCallbackProvider> toolCallbackProviders, List<Message> messages, List<String> toolNames, List<Media> media, @Nullable ChatOptions chatOptions, List<Advisor> advisors, Map<String, Object> advisorParams, ObservationRegistry observationRegistry, @Nullable ChatClientObservationConvention chatClientObservationConvention, Map<String, Object> toolContext, @Nullable TemplateRenderer templateRenderer, @Nullable AdvisorObservationConvention advisorObservationConvention) {
            Assert.notNull((Object)chatModel, (String)"chatModel cannot be null");
            Assert.notNull(userParams, (String)"userParams cannot be null");
            Assert.notNull(userMetadata, (String)"userMetadata cannot be null");
            Assert.notNull(systemParams, (String)"systemParams cannot be null");
            Assert.notNull(systemMetadata, (String)"systemMetadata cannot be null");
            Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
            Assert.notNull(toolCallbackProviders, (String)"toolCallbackProviders cannot be null");
            Assert.notNull(messages, (String)"messages cannot be null");
            Assert.notNull(toolNames, (String)"toolNames cannot be null");
            Assert.notNull(media, (String)"media cannot be null");
            Assert.notNull(advisors, (String)"advisors cannot be null");
            Assert.notNull(advisorParams, (String)"advisorParams cannot be null");
            Assert.notNull((Object)observationRegistry, (String)"observationRegistry cannot be null");
            Assert.notNull(toolContext, (String)"toolContext cannot be null");
            this.chatModel = chatModel;
            this.chatOptions = chatOptions != null ? chatOptions.copy() : (chatModel.getDefaultOptions() != null ? chatModel.getDefaultOptions().copy() : null);
            this.userText = userText;
            this.userParams.putAll(userParams);
            this.userMetadata.putAll(userMetadata);
            this.systemText = systemText;
            this.systemParams.putAll(systemParams);
            this.systemMetadata.putAll(systemMetadata);
            this.toolNames.addAll(toolNames);
            this.toolCallbacks.addAll(toolCallbacks);
            this.toolCallbackProviders.addAll(toolCallbackProviders);
            this.messages.addAll(messages);
            this.media.addAll(media);
            this.advisors.addAll(advisors);
            this.advisorParams.putAll(advisorParams);
            this.observationRegistry = observationRegistry;
            this.chatClientObservationConvention = chatClientObservationConvention != null ? chatClientObservationConvention : DEFAULT_CHAT_CLIENT_OBSERVATION_CONVENTION;
            this.toolContext.putAll(toolContext);
            this.templateRenderer = templateRenderer != null ? templateRenderer : DEFAULT_TEMPLATE_RENDERER;
            this.advisorObservationConvention = advisorObservationConvention;
        }

        public @Nullable String getUserText() {
            return this.userText;
        }

        public Map<String, Object> getUserParams() {
            return this.userParams;
        }

        public Map<String, Object> getUserMetadata() {
            return this.userMetadata;
        }

        public @Nullable String getSystemText() {
            return this.systemText;
        }

        public Map<String, Object> getSystemParams() {
            return this.systemParams;
        }

        public Map<String, Object> getSystemMetadata() {
            return this.systemMetadata;
        }

        public @Nullable ChatOptions getChatOptions() {
            return this.chatOptions;
        }

        public List<Advisor> getAdvisors() {
            return this.advisors;
        }

        public Map<String, Object> getAdvisorParams() {
            return this.advisorParams;
        }

        public List<Message> getMessages() {
            return this.messages;
        }

        public List<Media> getMedia() {
            return this.media;
        }

        public List<String> getToolNames() {
            return this.toolNames;
        }

        public List<ToolCallback> getToolCallbacks() {
            return this.toolCallbacks;
        }

        public List<ToolCallbackProvider> getToolCallbackProviders() {
            return this.toolCallbackProviders;
        }

        public Map<String, Object> getToolContext() {
            return this.toolContext;
        }

        public TemplateRenderer getTemplateRenderer() {
            return this.templateRenderer;
        }

        @Override
        public ChatClient.Builder mutate() {
            String text;
            DefaultChatClientBuilder builder = (DefaultChatClientBuilder)ChatClient.builder(this.chatModel, this.observationRegistry, this.chatClientObservationConvention, this.advisorObservationConvention).defaultTemplateRenderer(this.templateRenderer).defaultToolCallbacks(this.toolCallbacks).defaultToolCallbacks(this.toolCallbackProviders.toArray(new ToolCallbackProvider[0])).defaultToolContext(this.toolContext).defaultToolNames(StringUtils.toStringArray(this.toolNames));
            if (!CollectionUtils.isEmpty(this.advisors)) {
                builder.defaultAdvisors(a -> a.advisors(this.advisors).params(this.advisorParams));
            }
            if (StringUtils.hasText((String)this.userText)) {
                text = this.userText;
                builder.defaultUser(u -> u.text(text).params(this.userParams).media(this.media.toArray(new Media[0])).metadata(this.userMetadata));
            }
            if (StringUtils.hasText((String)this.systemText)) {
                text = this.systemText;
                builder.defaultSystem(s -> s.text(text).params(this.systemParams).metadata(this.systemMetadata));
            }
            if (this.chatOptions != null) {
                builder.defaultOptions(this.chatOptions);
            }
            builder.addMessages(this.messages);
            return builder;
        }

        @Override
        public ChatClient.ChatClientRequestSpec advisors(Consumer<ChatClient.AdvisorSpec> consumer) {
            Assert.notNull(consumer, (String)"consumer cannot be null");
            DefaultAdvisorSpec advisorSpec = new DefaultAdvisorSpec();
            consumer.accept(advisorSpec);
            this.advisorParams.putAll(advisorSpec.getParams());
            this.advisors.addAll(advisorSpec.getAdvisors());
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec advisors(Advisor ... advisors) {
            Assert.notNull((Object)advisors, (String)"advisors cannot be null");
            Assert.noNullElements((Object[])advisors, (String)"advisors cannot contain null elements");
            this.advisors.addAll(Arrays.asList(advisors));
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec advisors(List<Advisor> advisors) {
            Assert.notNull(advisors, (String)"advisors cannot be null");
            Assert.noNullElements(advisors, (String)"advisors cannot contain null elements");
            this.advisors.addAll(advisors);
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec messages(Message ... messages) {
            Assert.notNull((Object)messages, (String)"messages cannot be null");
            Assert.noNullElements((Object[])messages, (String)"messages cannot contain null elements");
            this.messages.addAll(List.of(messages));
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec messages(List<Message> messages) {
            Assert.notNull(messages, (String)"messages cannot be null");
            Assert.noNullElements(messages, (String)"messages cannot contain null elements");
            this.messages.addAll(messages);
            return this;
        }

        @Override
        public <T extends ChatOptions> ChatClient.ChatClientRequestSpec options(T options) {
            Assert.notNull(options, (String)"options cannot be null");
            this.chatOptions = options;
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec toolNames(String ... toolNames) {
            Assert.notNull((Object)toolNames, (String)"toolNames cannot be null");
            Assert.noNullElements((Object[])toolNames, (String)"toolNames cannot contain null elements");
            this.toolNames.addAll(List.of(toolNames));
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec toolCallbacks(ToolCallback ... toolCallbacks) {
            Assert.notNull((Object)toolCallbacks, (String)"toolCallbacks cannot be null");
            Assert.noNullElements((Object[])toolCallbacks, (String)"toolCallbacks cannot contain null elements");
            this.toolCallbacks.addAll(List.of(toolCallbacks));
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec toolCallbacks(List<ToolCallback> toolCallbacks) {
            Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
            Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
            this.toolCallbacks.addAll(toolCallbacks);
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec tools(Object ... toolObjects) {
            Assert.notNull((Object)toolObjects, (String)"toolObjects cannot be null");
            Assert.noNullElements((Object[])toolObjects, (String)"toolObjects cannot contain null elements");
            this.toolCallbacks.addAll(Arrays.asList(ToolCallbacks.from((Object[])toolObjects)));
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec toolCallbacks(ToolCallbackProvider ... toolCallbackProviders) {
            Assert.notNull((Object)toolCallbackProviders, (String)"toolCallbackProviders cannot be null");
            Assert.noNullElements((Object[])toolCallbackProviders, (String)"toolCallbackProviders cannot contain null elements");
            this.toolCallbackProviders.addAll(List.of(toolCallbackProviders));
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec toolContext(Map<String, Object> toolContext) {
            Assert.notNull(toolContext, (String)"toolContext cannot be null");
            Assert.noNullElements(toolContext.keySet(), (String)"toolContext keys cannot contain null elements");
            Assert.noNullElements(toolContext.values(), (String)"toolContext values cannot contain null elements");
            this.toolContext.putAll(toolContext);
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec system(String text) {
            Assert.hasText((String)text, (String)"text cannot be null or empty");
            this.systemText = text;
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec system(Resource text, Charset charset) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            Assert.notNull((Object)charset, (String)"charset cannot be null");
            try {
                this.systemText = text.getContentAsString(charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec system(Resource text) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            return this.system(text, Charset.defaultCharset());
        }

        @Override
        public ChatClient.ChatClientRequestSpec system(Consumer<ChatClient.PromptSystemSpec> consumer) {
            Assert.notNull(consumer, (String)"consumer cannot be null");
            DefaultPromptSystemSpec systemSpec = new DefaultPromptSystemSpec();
            consumer.accept(systemSpec);
            this.systemText = StringUtils.hasText((String)systemSpec.text()) ? systemSpec.text() : this.systemText;
            this.systemParams.putAll(systemSpec.params());
            this.systemMetadata.putAll(systemSpec.metadata());
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec user(String text) {
            Assert.hasText((String)text, (String)"text cannot be null or empty");
            this.userText = text;
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec user(Resource text, Charset charset) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            Assert.notNull((Object)charset, (String)"charset cannot be null");
            try {
                this.userText = text.getContentAsString(charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec user(Resource text) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            return this.user(text, Charset.defaultCharset());
        }

        @Override
        public ChatClient.ChatClientRequestSpec user(Consumer<ChatClient.PromptUserSpec> consumer) {
            Assert.notNull(consumer, (String)"consumer cannot be null");
            DefaultPromptUserSpec us = new DefaultPromptUserSpec();
            consumer.accept(us);
            this.userText = StringUtils.hasText((String)us.text()) ? us.text() : this.userText;
            this.userParams.putAll(us.params());
            this.media.addAll(us.media());
            this.userMetadata.putAll(us.metadata());
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec templateRenderer(TemplateRenderer templateRenderer) {
            Assert.notNull((Object)templateRenderer, (String)"templateRenderer cannot be null");
            this.templateRenderer = templateRenderer;
            return this;
        }

        @Override
        public ChatClient.CallResponseSpec call() {
            BaseAdvisorChain advisorChain = this.buildAdvisorChain();
            return new DefaultCallResponseSpec(DefaultChatClientUtils.toChatClientRequest(this), advisorChain, this.observationRegistry, this.chatClientObservationConvention);
        }

        @Override
        public ChatClient.StreamResponseSpec stream() {
            BaseAdvisorChain advisorChain = this.buildAdvisorChain();
            return new DefaultStreamResponseSpec(DefaultChatClientUtils.toChatClientRequest(this), advisorChain, this.observationRegistry, this.chatClientObservationConvention);
        }

        private BaseAdvisorChain buildAdvisorChain() {
            this.advisors.add(ChatModelCallAdvisor.builder().chatModel(this.chatModel).build());
            this.advisors.add(ChatModelStreamAdvisor.builder().chatModel(this.chatModel).build());
            return DefaultAroundAdvisorChain.builder(this.observationRegistry).observationConvention(this.advisorObservationConvention).pushAll(this.advisors).build();
        }
    }

    public static class DefaultStreamResponseSpec
    implements ChatClient.StreamResponseSpec {
        private final ChatClientRequest request;
        private final BaseAdvisorChain advisorChain;
        private final ObservationRegistry observationRegistry;
        private final ChatClientObservationConvention observationConvention;

        public DefaultStreamResponseSpec(ChatClientRequest chatClientRequest, BaseAdvisorChain advisorChain, ObservationRegistry observationRegistry, ChatClientObservationConvention observationConvention) {
            Assert.notNull((Object)chatClientRequest, (String)"chatClientRequest cannot be null");
            Assert.notNull((Object)advisorChain, (String)"advisorChain cannot be null");
            Assert.notNull((Object)observationRegistry, (String)"observationRegistry cannot be null");
            Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
            this.request = chatClientRequest;
            this.advisorChain = advisorChain;
            this.observationRegistry = observationRegistry;
            this.observationConvention = observationConvention;
        }

        private Flux<ChatClientResponse> doGetObservableFluxChatResponse(ChatClientRequest chatClientRequest) {
            return Flux.deferContextual(contextView -> {
                ChatClientObservationContext observationContext = ChatClientObservationContext.builder().request(chatClientRequest).advisors(this.advisorChain.getStreamAdvisors()).stream(true).build();
                Observation observation = ChatClientObservationDocumentation.AI_CHAT_CLIENT.observation(this.observationConvention, DEFAULT_CHAT_CLIENT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
                observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
                Flux chatClientResponse = this.advisorChain.nextStream(chatClientRequest).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
                return CHAT_CLIENT_MESSAGE_AGGREGATOR.aggregateChatClientResponse((Flux<ChatClientResponse>)chatClientResponse, observationContext::setResponse);
            });
        }

        @Override
        public Flux<ChatClientResponse> chatClientResponse() {
            return this.doGetObservableFluxChatResponse(this.request);
        }

        @Override
        public Flux<ChatResponse> chatResponse() {
            return this.doGetObservableFluxChatResponse(this.request).mapNotNull(ChatClientResponse::chatResponse);
        }

        @Override
        public Flux<String> content() {
            return this.chatResponse().map(r -> Optional.ofNullable(r.getResult()).map(Generation::getOutput).map(AbstractMessage::getText).orElse("")).filter(StringUtils::hasLength);
        }
    }

    public static class DefaultCallResponseSpec
    implements ChatClient.CallResponseSpec {
        private final ChatClientRequest request;
        private final BaseAdvisorChain advisorChain;
        private final ObservationRegistry observationRegistry;
        private final ChatClientObservationConvention observationConvention;

        public DefaultCallResponseSpec(ChatClientRequest chatClientRequest, BaseAdvisorChain advisorChain, ObservationRegistry observationRegistry, ChatClientObservationConvention observationConvention) {
            Assert.notNull((Object)chatClientRequest, (String)"chatClientRequest cannot be null");
            Assert.notNull((Object)advisorChain, (String)"advisorChain cannot be null");
            Assert.notNull((Object)observationRegistry, (String)"observationRegistry cannot be null");
            Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
            this.request = chatClientRequest;
            this.advisorChain = advisorChain;
            this.observationRegistry = observationRegistry;
            this.observationConvention = observationConvention;
        }

        @Override
        public <T> ResponseEntity<ChatResponse, T> responseEntity(Class<T> type) {
            Assert.notNull(type, (String)"type cannot be null");
            return this.doResponseEntity((StructuredOutputConverter<T>)new BeanOutputConverter(type));
        }

        @Override
        public <T> ResponseEntity<ChatResponse, T> responseEntity(ParameterizedTypeReference<T> type) {
            Assert.notNull(type, (String)"type cannot be null");
            return this.doResponseEntity((StructuredOutputConverter<T>)new BeanOutputConverter(type));
        }

        @Override
        public <T> ResponseEntity<ChatResponse, T> responseEntity(StructuredOutputConverter<T> structuredOutputConverter) {
            Assert.notNull(structuredOutputConverter, (String)"structuredOutputConverter cannot be null");
            return this.doResponseEntity(structuredOutputConverter);
        }

        protected <T> ResponseEntity<ChatResponse, T> doResponseEntity(StructuredOutputConverter<T> outputConverter) {
            ChatResponse chatResponse;
            String responseContent;
            Assert.notNull(outputConverter, (String)"structuredOutputConverter cannot be null");
            this.request.context().put(ChatClientAttributes.OUTPUT_FORMAT.getKey(), outputConverter.getFormat());
            if (this.request.context().containsKey(ChatClientAttributes.STRUCTURED_OUTPUT_NATIVE.getKey()) && outputConverter instanceof BeanOutputConverter) {
                BeanOutputConverter beanOutputConverter = (BeanOutputConverter)outputConverter;
                this.request.context().put(ChatClientAttributes.STRUCTURED_OUTPUT_SCHEMA.getKey(), beanOutputConverter.getJsonSchema());
            }
            if ((responseContent = DefaultCallResponseSpec.getContentFromChatResponse(chatResponse = this.doGetObservableChatClientResponse(this.request).chatResponse())) == null) {
                return new ResponseEntity<ChatResponse, Object>(chatResponse, null);
            }
            Object entity2 = outputConverter.convert((Object)responseContent);
            return new ResponseEntity<ChatResponse, Object>(chatResponse, entity2);
        }

        @Override
        public <T> @Nullable T entity(ParameterizedTypeReference<T> type) {
            Assert.notNull(type, (String)"type cannot be null");
            return this.doSingleWithBeanOutputConverter((StructuredOutputConverter<T>)new BeanOutputConverter(type));
        }

        @Override
        public <T> @Nullable T entity(StructuredOutputConverter<T> structuredOutputConverter) {
            Assert.notNull(structuredOutputConverter, (String)"structuredOutputConverter cannot be null");
            return this.doSingleWithBeanOutputConverter(structuredOutputConverter);
        }

        @Override
        public <T> @Nullable T entity(Class<T> type) {
            Assert.notNull(type, (String)"type cannot be null");
            BeanOutputConverter outputConverter = new BeanOutputConverter(type);
            return this.doSingleWithBeanOutputConverter((StructuredOutputConverter<T>)outputConverter);
        }

        private <T> @Nullable T doSingleWithBeanOutputConverter(StructuredOutputConverter<T> outputConverter) {
            ChatResponse chatResponse;
            String stringResponse;
            if (StringUtils.hasText((String)outputConverter.getFormat())) {
                this.request.context().put(ChatClientAttributes.OUTPUT_FORMAT.getKey(), outputConverter.getFormat());
            }
            if (this.request.context().containsKey(ChatClientAttributes.STRUCTURED_OUTPUT_NATIVE.getKey()) && outputConverter instanceof BeanOutputConverter) {
                BeanOutputConverter beanOutputConverter = (BeanOutputConverter)outputConverter;
                this.request.context().put(ChatClientAttributes.STRUCTURED_OUTPUT_SCHEMA.getKey(), beanOutputConverter.getJsonSchema());
            }
            if ((stringResponse = DefaultCallResponseSpec.getContentFromChatResponse(chatResponse = this.doGetObservableChatClientResponse(this.request).chatResponse())) == null) {
                return null;
            }
            return (T)outputConverter.convert((Object)stringResponse);
        }

        @Override
        public ChatClientResponse chatClientResponse() {
            return this.doGetObservableChatClientResponse(this.request);
        }

        @Override
        public @Nullable ChatResponse chatResponse() {
            return this.doGetObservableChatClientResponse(this.request).chatResponse();
        }

        @Override
        public @Nullable String content() {
            ChatResponse chatResponse = this.doGetObservableChatClientResponse(this.request).chatResponse();
            return DefaultCallResponseSpec.getContentFromChatResponse(chatResponse);
        }

        private ChatClientResponse doGetObservableChatClientResponse(ChatClientRequest chatClientRequest) {
            String outputFormat = chatClientRequest.context().getOrDefault(ChatClientAttributes.OUTPUT_FORMAT.getKey(), null);
            ChatClientObservationContext observationContext = ChatClientObservationContext.builder().request(chatClientRequest).advisors(this.advisorChain.getCallAdvisors()).stream(false).format(outputFormat).build();
            Observation observation = ChatClientObservationDocumentation.AI_CHAT_CLIENT.observation(this.observationConvention, DEFAULT_CHAT_CLIENT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            ChatClientResponse chatClientResponse = (ChatClientResponse)observation.observe(() -> {
                ChatClientResponse response = this.advisorChain.nextCall(chatClientRequest);
                observationContext.setResponse(response);
                return response;
            });
            return chatClientResponse != null ? chatClientResponse : ChatClientResponse.builder().build();
        }

        private static @Nullable String getContentFromChatResponse(@Nullable ChatResponse chatResponse) {
            return Optional.ofNullable(chatResponse).map(ChatResponse::getResult).map(Generation::getOutput).map(AbstractMessage::getText).orElse(null);
        }
    }

    public static class DefaultAdvisorSpec
    implements ChatClient.AdvisorSpec {
        private final List<Advisor> advisors = new ArrayList<Advisor>();
        private final Map<String, Object> params = new HashMap<String, Object>();

        @Override
        public ChatClient.AdvisorSpec param(String key, Object value) {
            Assert.hasText((String)key, (String)"key cannot be null or empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.params.put(key, value);
            return this;
        }

        @Override
        public ChatClient.AdvisorSpec params(Map<String, Object> params) {
            Assert.notNull(params, (String)"params cannot be null");
            Assert.noNullElements(params.keySet(), (String)"param keys cannot contain null elements");
            Assert.noNullElements(params.values(), (String)"param values cannot contain null elements");
            this.params.putAll(params);
            return this;
        }

        @Override
        public ChatClient.AdvisorSpec advisors(Advisor ... advisors) {
            Assert.notNull((Object)advisors, (String)"advisors cannot be null");
            Assert.noNullElements((Object[])advisors, (String)"advisors cannot contain null elements");
            this.advisors.addAll(List.of(advisors));
            return this;
        }

        @Override
        public ChatClient.AdvisorSpec advisors(List<Advisor> advisors) {
            Assert.notNull(advisors, (String)"advisors cannot be null");
            Assert.noNullElements(advisors, (String)"advisors cannot contain null elements");
            this.advisors.addAll(advisors);
            return this;
        }

        public List<Advisor> getAdvisors() {
            return this.advisors;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }
    }

    public static class DefaultPromptSystemSpec
    implements ChatClient.PromptSystemSpec {
        private final Map<String, Object> params = new HashMap<String, Object>();
        private final Map<String, Object> metadata = new HashMap<String, Object>();
        private @Nullable String text;

        @Override
        public ChatClient.PromptSystemSpec text(String text) {
            Assert.hasText((String)text, (String)"text cannot be null or empty");
            this.text = text;
            return this;
        }

        @Override
        public ChatClient.PromptSystemSpec text(Resource text, Charset charset) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            Assert.notNull((Object)charset, (String)"charset cannot be null");
            try {
                this.text(text.getContentAsString(charset));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public ChatClient.PromptSystemSpec text(Resource text) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            this.text(text, Charset.defaultCharset());
            return this;
        }

        @Override
        public ChatClient.PromptSystemSpec param(String key, Object value) {
            Assert.hasText((String)key, (String)"key cannot be null or empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.params.put(key, value);
            return this;
        }

        @Override
        public ChatClient.PromptSystemSpec params(Map<String, Object> params) {
            Assert.notNull(params, (String)"params cannot be null");
            Assert.noNullElements(params.keySet(), (String)"param keys cannot contain null elements");
            Assert.noNullElements(params.values(), (String)"param values cannot contain null elements");
            this.params.putAll(params);
            return this;
        }

        @Override
        public ChatClient.PromptSystemSpec metadata(Map<String, Object> metadata) {
            Assert.notNull(metadata, (String)"metadata cannot be null");
            Assert.noNullElements(metadata.keySet(), (String)"metadata keys cannot contain null elements");
            Assert.noNullElements(metadata.values(), (String)"metadata values cannot contain null elements");
            this.metadata.putAll(metadata);
            return this;
        }

        @Override
        public ChatClient.PromptSystemSpec metadata(String key, Object value) {
            Assert.hasText((String)key, (String)"metadata key cannot be null or empty");
            Assert.notNull((Object)value, (String)"metadata value cannot be null");
            this.metadata.put(key, value);
            return this;
        }

        protected @Nullable String text() {
            return this.text;
        }

        protected Map<String, Object> params() {
            return this.params;
        }

        protected Map<String, Object> metadata() {
            return this.metadata;
        }
    }

    public static class DefaultPromptUserSpec
    implements ChatClient.PromptUserSpec {
        private final Map<String, Object> params = new HashMap<String, Object>();
        private final Map<String, Object> metadata = new HashMap<String, Object>();
        private final List<Media> media = new ArrayList<Media>();
        private @Nullable String text;

        @Override
        public ChatClient.PromptUserSpec media(Media ... media) {
            Assert.notNull((Object)media, (String)"media cannot be null");
            Assert.noNullElements((Object[])media, (String)"media cannot contain null elements");
            this.media.addAll(Arrays.asList(media));
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec media(MimeType mimeType, URL url) {
            Assert.notNull((Object)mimeType, (String)"mimeType cannot be null");
            Assert.notNull((Object)url, (String)"url cannot be null");
            try {
                this.media.add(Media.builder().mimeType(mimeType).data(url.toURI()).build());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec media(MimeType mimeType, Resource resource) {
            Assert.notNull((Object)mimeType, (String)"mimeType cannot be null");
            Assert.notNull((Object)resource, (String)"resource cannot be null");
            this.media.add(Media.builder().mimeType(mimeType).data(resource).build());
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec text(String text) {
            Assert.hasText((String)text, (String)"text cannot be null or empty");
            this.text = text;
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec text(Resource text, Charset charset) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            Assert.notNull((Object)charset, (String)"charset cannot be null");
            try {
                this.text(text.getContentAsString(charset));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec text(Resource text) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            this.text(text, Charset.defaultCharset());
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec param(String key, Object value) {
            Assert.hasText((String)key, (String)"key cannot be null or empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.params.put(key, value);
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec params(Map<String, Object> params) {
            Assert.notNull(params, (String)"params cannot be null");
            Assert.noNullElements(params.keySet(), (String)"param keys cannot contain null elements");
            Assert.noNullElements(params.values(), (String)"param values cannot contain null elements");
            this.params.putAll(params);
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec metadata(Map<String, Object> metadata) {
            Assert.notNull(metadata, (String)"metadata cannot be null");
            Assert.noNullElements(metadata.keySet(), (String)"metadata keys cannot contain null elements");
            Assert.noNullElements(metadata.values(), (String)"metadata values cannot contain null elements");
            this.metadata.putAll(metadata);
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec metadata(String key, Object value) {
            Assert.hasText((String)key, (String)"metadata key cannot be null or empty");
            Assert.notNull((Object)value, (String)"metadata value cannot be null");
            this.metadata.put(key, value);
            return this;
        }

        protected @Nullable String text() {
            return this.text;
        }

        protected Map<String, Object> params() {
            return this.params;
        }

        protected List<Media> media() {
            return this.media;
        }

        protected Map<String, Object> metadata() {
            return this.metadata;
        }
    }
}

