/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.advisor;

import java.util.List;
import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.client.advisor.api.CallAdvisor;
import org.springframework.ai.chat.client.advisor.api.CallAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.StreamAdvisor;
import org.springframework.ai.chat.client.advisor.api.StreamAdvisorChain;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionResult;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

public class ToolCallAdvisor
implements CallAdvisor,
StreamAdvisor {
    protected final ToolCallingManager toolCallingManager;
    private final int advisorOrder;

    protected ToolCallAdvisor(ToolCallingManager toolCallingManager, int advisorOrder) {
        Assert.notNull((Object)toolCallingManager, (String)"toolCallingManager must not be null");
        Assert.isTrue((advisorOrder > Integer.MIN_VALUE && advisorOrder < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"advisorOrder must be between HIGHEST_PRECEDENCE and LOWEST_PRECEDENCE");
        this.toolCallingManager = toolCallingManager;
        this.advisorOrder = advisorOrder;
    }

    @Override
    public String getName() {
        return "Tool Calling Advisor";
    }

    public int getOrder() {
        return this.advisorOrder;
    }

    @Override
    public ChatClientResponse adviseCall(ChatClientRequest chatClientRequest, CallAdvisorChain callAdvisorChain) {
        Assert.notNull((Object)callAdvisorChain, (String)"callAdvisorChain must not be null");
        Assert.notNull((Object)chatClientRequest, (String)"chatClientRequest must not be null");
        if (chatClientRequest.prompt().getOptions() == null || !(chatClientRequest.prompt().getOptions() instanceof ToolCallingChatOptions)) {
            throw new IllegalArgumentException("ToolCall Advisor requires ToolCallingChatOptions to be set in the ChatClientRequest options.");
        }
        chatClientRequest = this.doInitializeLoop(chatClientRequest, callAdvisorChain);
        ToolCallingChatOptions optionsCopy = (ToolCallingChatOptions)chatClientRequest.prompt().getOptions().copy();
        optionsCopy.setInternalToolExecutionEnabled(Boolean.valueOf(false));
        List instructions = chatClientRequest.prompt().getInstructions();
        ChatClientResponse chatClientResponse = null;
        boolean isToolCall = false;
        do {
            ChatClientRequest processedChatClientRequest = ChatClientRequest.builder().prompt(new Prompt(instructions, (ChatOptions)optionsCopy)).context(chatClientRequest.context()).build();
            processedChatClientRequest = this.doBeforeCall(processedChatClientRequest, callAdvisorChain);
            chatClientResponse = callAdvisorChain.copy(this).nextCall(processedChatClientRequest);
            boolean bl = isToolCall = (chatClientResponse = this.doAfterCall(chatClientResponse, callAdvisorChain)).chatResponse() != null && chatClientResponse.chatResponse().hasToolCalls();
            if (!isToolCall) continue;
            ToolExecutionResult toolExecutionResult = this.toolCallingManager.executeToolCalls(processedChatClientRequest.prompt(), chatClientResponse.chatResponse());
            if (toolExecutionResult.returnDirect()) {
                chatClientResponse = chatClientResponse.mutate().chatResponse(ChatResponse.builder().from(chatClientResponse.chatResponse()).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build()).build();
                break;
            }
            instructions = toolExecutionResult.conversationHistory();
        } while (isToolCall);
        return this.doFinalizeLoop(chatClientResponse, callAdvisorChain);
    }

    protected ChatClientResponse doFinalizeLoop(ChatClientResponse chatClientResponse, CallAdvisorChain callAdvisorChain) {
        return chatClientResponse;
    }

    protected ChatClientRequest doInitializeLoop(ChatClientRequest chatClientRequest, CallAdvisorChain callAdvisorChain) {
        return chatClientRequest;
    }

    protected ChatClientRequest doBeforeCall(ChatClientRequest chatClientRequest, CallAdvisorChain callAdvisorChain) {
        return chatClientRequest;
    }

    protected ChatClientResponse doAfterCall(ChatClientResponse chatClientResponse, CallAdvisorChain callAdvisorChain) {
        return chatClientResponse;
    }

    @Override
    public Flux<ChatClientResponse> adviseStream(ChatClientRequest chatClientRequest, StreamAdvisorChain streamAdvisorChain) {
        return Flux.error((Throwable)new UnsupportedOperationException("Unimplemented method 'adviseStream'"));
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>> {
        private ToolCallingManager toolCallingManager = ToolCallingManager.builder().build();
        private int advisorOrder = -2147483348;

        protected Builder() {
        }

        protected T self() {
            return (T)this;
        }

        public T toolCallingManager(ToolCallingManager toolCallingManager) {
            this.toolCallingManager = toolCallingManager;
            return this.self();
        }

        public T advisorOrder(int advisorOrder) {
            this.advisorOrder = advisorOrder;
            return this.self();
        }

        protected ToolCallingManager getToolCallingManager() {
            return this.toolCallingManager;
        }

        protected int getAdvisorOrder() {
            return this.advisorOrder;
        }

        public ToolCallAdvisor build() {
            return new ToolCallAdvisor(this.toolCallingManager, this.advisorOrder);
        }
    }
}

