/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import io.swagger.v3.oas.annotations.Operation;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SwaggerUiConfigParameters;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.webflux.ui.SwaggerWelcomeCommon;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.reactive.result.condition.PatternsRequestCondition;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import org.springframework.web.reactive.result.method.RequestMappingInfoHandlerMapping;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.pattern.PathPattern;
import reactor.core.publisher.Mono;

@Controller
public class SwaggerWelcomeWebFlux
extends SwaggerWelcomeCommon {
    private final Optional<RequestMappingInfoHandlerMapping> requestMappingInfoHandlerMappingOptional;
    private String pathPrefix;

    public SwaggerWelcomeWebFlux(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, SwaggerUiConfigParameters swaggerUiConfigParameters, Optional<RequestMappingInfoHandlerMapping> requestMappingInfoHandlerMappingOptional) {
        super(swaggerUiConfig, springDocConfigProperties, swaggerUiConfigParameters);
        this.requestMappingInfoHandlerMappingOptional = requestMappingInfoHandlerMappingOptional;
    }

    @PostConstruct
    private void init() {
        this.requestMappingInfoHandlerMappingOptional.ifPresent(requestMappingHandlerMapping -> {
            Map map = requestMappingHandlerMapping.getHandlerMethods();
            ArrayList entries = new ArrayList(map.entrySet());
            for (Map.Entry entry : entries) {
                RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entry.getKey();
                PatternsRequestCondition patternsRequestCondition = requestMappingInfo.getPatternsCondition();
                Set patterns = patternsRequestCondition.getPatterns();
                for (PathPattern pathPattern : patterns) {
                    String operationPath = pathPattern.getPatternString();
                    if (!operationPath.endsWith(this.springDocConfigProperties.getApiDocs().getPath())) continue;
                    this.pathPrefix = operationPath.replace(this.springDocConfigProperties.getApiDocs().getPath(), "");
                }
            }
        });
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}"})
    public Mono<Void> redirectToUi(ServerHttpRequest request, ServerHttpResponse response) {
        return super.redirectToUi(request, response);
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}/swagger-config"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> getSwaggerUiConfig(ServerHttpRequest request) {
        return super.getSwaggerUiConfig(request);
    }

    protected void calculateUiRootPath(StringBuilder ... sbUrls) {
        StringBuilder sbUrl = new StringBuilder();
        this.calculateUiRootCommon(sbUrl, sbUrls);
    }

    protected void calculateOauth2RedirectUrl(UriComponentsBuilder uriComponentsBuilder) {
        if (this.oauthPrefix == null && !this.swaggerUiConfigParameters.isValidUrl(this.swaggerUiConfigParameters.getOauth2RedirectUrl()) || this.springDocConfigProperties.isCacheDisabled()) {
            this.oauthPrefix = uriComponentsBuilder.path(this.contextPath).path(this.swaggerUiConfigParameters.getUiRootPath()).path(this.webJarsPrefixUrl);
            this.swaggerUiConfigParameters.setOauth2RedirectUrl(this.oauthPrefix.path(this.getOauth2RedirectUrl()).build().toString());
        }
    }

    protected String buildApiDocUrl() {
        return this.buildUrl(this.contextPath + this.pathPrefix, this.springDocConfigProperties.getApiDocs().getPath());
    }

    protected String buildSwaggerConfigUrl() {
        return this.apiDocsUrl + "/" + "swagger-config";
    }
}

