/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.core.SwaggerUiOAuthProperties;
import org.springdoc.ui.AbstractSwaggerIndexTransformer;
import org.springdoc.ui.SpringDocUIException;
import org.springframework.core.io.Resource;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.resource.ResourceTransformer;
import org.springframework.web.reactive.resource.ResourceTransformerChain;
import org.springframework.web.reactive.resource.TransformedResource;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SwaggerIndexTransformer
extends AbstractSwaggerIndexTransformer
implements ResourceTransformer {
    public SwaggerIndexTransformer(SwaggerUiConfigProperties swaggerUiConfig, SwaggerUiOAuthProperties swaggerUiOAuthProperties, ObjectMapper objectMapper) {
        super(swaggerUiConfig, swaggerUiOAuthProperties, objectMapper);
    }

    public Mono<Resource> transform(ServerWebExchange serverWebExchange, Resource resource, ResourceTransformerChain resourceTransformerChain) {
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        boolean isIndexFound = false;
        try {
            isIndexFound = antPathMatcher.match("**/swagger-ui/**/index.html", resource.getURL().toString());
            if (isIndexFound && !CollectionUtils.isEmpty((Map)this.swaggerUiOAuthProperties.getConfigParameters()) && this.swaggerUiConfig.isDisableSwaggerDefaultUrl()) {
                String html = this.readFullyAsString(resource.getInputStream());
                html = this.addInitOauth(html);
                html = this.overwriteSwaggerDefaultUrl(html);
                return Mono.just((Object)new TransformedResource(resource, html.getBytes()));
            }
            if (isIndexFound && !CollectionUtils.isEmpty((Map)this.swaggerUiOAuthProperties.getConfigParameters())) {
                String html = this.readFullyAsString(resource.getInputStream());
                html = this.addInitOauth(html);
                return Mono.just((Object)new TransformedResource(resource, html.getBytes()));
            }
            if (isIndexFound && this.swaggerUiConfig.isDisableSwaggerDefaultUrl()) {
                String html = this.readFullyAsString(resource.getInputStream());
                html = this.overwriteSwaggerDefaultUrl(html);
                return Mono.just((Object)new TransformedResource(resource, html.getBytes()));
            }
            return Mono.just((Object)resource);
        }
        catch (Exception e) {
            throw new SpringDocUIException("Failed to transform Index", (Throwable)e);
        }
    }
}

