/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import io.swagger.v3.oas.annotations.Operation;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SpringDocConfiguration;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.ui.AbstractSwaggerWelcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@Controller
@ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={SpringDocConfiguration.class})
public class SwaggerWelcome
extends AbstractSwaggerWelcome {
    private String webJarsPrefixUrl;
    private UriComponentsBuilder oauthPrefix;

    public SwaggerWelcome(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties) {
        super(swaggerUiConfig, springDocConfigProperties);
        this.webJarsPrefixUrl = springDocConfigProperties.getWebjars().getPrefix();
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}"})
    public Mono<Void> redirectToUi(ServerHttpRequest request, ServerHttpResponse response) {
        String contextPath = this.fromCurrentContextPath(request);
        String sbUrl = this.buildUrl(contextPath, this.uiRootPath + this.springDocConfigProperties.getWebjars().getPrefix() + "/swagger-ui/index.html");
        UriComponentsBuilder uriBuilder = this.getUriComponentsBuilder(sbUrl);
        response.setStatusCode(HttpStatus.TEMPORARY_REDIRECT);
        response.getHeaders().setLocation(URI.create(uriBuilder.build().encode().toString()));
        return response.setComplete();
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}/swagger-config"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> getSwaggerUiConfig(ServerHttpRequest request) {
        this.fromCurrentContextPath(request);
        return this.swaggerUiConfig.getConfigParameters();
    }

    protected void calculateUiRootPath(StringBuilder ... sbUrls) {
        String swaggerPath;
        StringBuilder sbUrl = new StringBuilder();
        if (ArrayUtils.isNotEmpty((Object[])sbUrls)) {
            sbUrl = sbUrls[0];
        }
        if ((swaggerPath = this.swaggerUiConfig.getPath()).contains("/")) {
            sbUrl.append(swaggerPath, 0, swaggerPath.lastIndexOf("/"));
        }
        this.uiRootPath = sbUrl.toString();
    }

    protected void calculateOauth2RedirectUrl(UriComponentsBuilder uriComponentsBuilder) {
        if (this.oauthPrefix == null && !this.swaggerUiConfig.isValidUrl(this.swaggerUiConfig.getOauth2RedirectUrl())) {
            this.oauthPrefix = uriComponentsBuilder.path(this.uiRootPath).path(this.webJarsPrefixUrl);
            this.swaggerUiConfig.setOauth2RedirectUrl(this.oauthPrefix.path(this.swaggerUiConfig.getOauth2RedirectUrl()).build().toString());
        }
    }

    private String fromCurrentContextPath(ServerHttpRequest request) {
        String contextPath = request.getPath().contextPath().value();
        String url = UriComponentsBuilder.fromHttpRequest((HttpRequest)request).toUriString();
        url = url.replace(request.getPath().toString(), "");
        this.buildConfigUrl(contextPath, UriComponentsBuilder.fromUriString((String)url));
        return contextPath;
    }
}

