/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.SpringDocConfiguration;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={SpringDocConfiguration.class})
public class SwaggerWelcome {
    @Autowired
    public SwaggerUiConfigProperties swaggerUiConfig;
    @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}")
    private String apiDocsUrl;
    @Value(value="${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}")
    private String uiPath;
    @Value(value="${springdoc.webjars.prefix:/webjars}")
    private String webJarsPrefixUrl;
    @Value(value="${springdoc.swagger-ui.url:#{null}}")
    private String swaggerUiUrl;
    @Value(value="${springdoc.swagger-ui.configUrl:#{null}}")
    private String originConfigUrl;

    @Bean
    @ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
    RouterFunction<ServerResponse> routerFunction() {
        String baseUrl = this.webJarsPrefixUrl + "/swagger-ui/index.html";
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)baseUrl);
        this.buildConfigUrl();
        uriBuilder.queryParam("configUrl", new Object[]{this.swaggerUiConfig.getConfigUrl()});
        return RouterFunctions.route((RequestPredicate)RequestPredicates.GET((String)this.uiPath), req -> ServerResponse.temporaryRedirect((URI)URI.create(uriBuilder.build().encode().toString())).build());
    }

    @Bean
    @ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
    RouterFunction<ServerResponse> getSwaggerUiConfig() {
        this.buildConfigUrl();
        return RouterFunctions.route((RequestPredicate)RequestPredicates.GET((String)this.swaggerUiConfig.getConfigUrl()).and(RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON})), req -> ServerResponse.ok().contentType(MediaType.APPLICATION_JSON).bodyValue((Object)this.swaggerUiConfig.getConfigParameters()));
    }

    private void buildConfigUrl() {
        if (StringUtils.isEmpty((CharSequence)this.originConfigUrl)) {
            String swaggerConfigUrl = this.apiDocsUrl + "/" + "swagger-config";
            this.swaggerUiConfig.setConfigUrl(swaggerConfigUrl);
            if (SwaggerUiConfigProperties.getSwaggerUrls().isEmpty()) {
                if (StringUtils.isEmpty((CharSequence)this.swaggerUiUrl)) {
                    this.swaggerUiConfig.setUrl(this.apiDocsUrl);
                } else {
                    this.swaggerUiConfig.setUrl(this.swaggerUiUrl);
                }
            } else {
                SwaggerUiConfigProperties.addUrl((String)this.apiDocsUrl);
            }
        }
    }
}

