/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.ui;

import io.swagger.v3.oas.annotations.Operation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SwaggerUiConfigParameters;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.webmvc.ui.SwaggerWelcomeCommon;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SwaggerWelcomeWebMvc
extends SwaggerWelcomeCommon {
    @Value(value="${spring.mvc.servlet.path:#{null}}")
    private String mvcServletPath;

    public SwaggerWelcomeWebMvc(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, SwaggerUiConfigParameters swaggerUiConfigParameters) {
        super(swaggerUiConfig, springDocConfigProperties, swaggerUiConfigParameters);
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}"})
    public ResponseEntity<Void> redirectToUi(HttpServletRequest request) {
        return super.redirectToUi(request);
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}/swagger-config"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> openapiJson(HttpServletRequest request) {
        return super.openapiJson(request);
    }

    protected void calculateUiRootPath(StringBuilder ... sbUrls) {
        StringBuilder sbUrl = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.mvcServletPath)) {
            sbUrl.append(this.mvcServletPath);
        }
        this.calculateUiRootCommon(sbUrl, sbUrls);
    }

    protected String buildUrl(String contextPath, String docsUrl) {
        if (StringUtils.isNotBlank((CharSequence)this.mvcServletPath)) {
            contextPath = contextPath + this.mvcServletPath;
        }
        return super.buildUrl(contextPath, docsUrl);
    }

    protected String buildApiDocUrl() {
        return this.buildUrl(this.contextPath, this.springDocConfigProperties.getApiDocs().getPath());
    }

    protected String buildSwaggerConfigUrl() {
        return this.apiDocsUrl + "/" + "swagger-config";
    }
}

