/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SpringDocConfiguration;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.core.SwaggerUiOAuthProperties;
import org.springdoc.ui.SwaggerIndexTransformer;
import org.springdoc.ui.SwaggerWelcome;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.resource.ResourceTransformer;

@Configuration
@ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={SpringDocConfiguration.class})
public class SwaggerConfig
extends WebMvcConfigurerAdapter {
    @Value(value="${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}")
    private String swaggerPath;
    @Value(value="${springdoc.webjars.prefix:/webjars}")
    private String webJarsPrefixUrl;
    @Autowired
    private SwaggerIndexTransformer swaggerIndexTransformer;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        StringBuilder uiRootPath = new StringBuilder();
        if (this.swaggerPath.contains("/")) {
            uiRootPath.append(this.swaggerPath, 0, this.swaggerPath.lastIndexOf(47));
        }
        uiRootPath.append("/**");
        String webJarsLocation = this.webJarsPrefixUrl + "/";
        registry.addResourceHandler(new String[]{uiRootPath + "/swagger-ui/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources" + webJarsLocation}).resourceChain(false).addTransformer((ResourceTransformer)this.swaggerIndexTransformer);
    }

    @Bean
    @ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
    public SwaggerWelcome swaggerWelcome(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties) {
        return new SwaggerWelcome(swaggerUiConfig, springDocConfigProperties);
    }

    @Bean
    @ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
    public SwaggerIndexTransformer indexPageTransformer(SwaggerUiOAuthProperties swaggerUiOAuthProperties, ObjectMapper objectMapper) {
        return new SwaggerIndexTransformer(swaggerUiOAuthProperties, objectMapper);
    }
}

