/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.ui;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.ui.AbstractSwaggerWelcome;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class SwaggerWelcomeCommon
extends AbstractSwaggerWelcome {
    public SwaggerWelcomeCommon(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, SwaggerUiConfigParameters swaggerUiConfigParameters) {
        super(swaggerUiConfig, springDocConfigProperties, swaggerUiConfigParameters);
    }

    protected ResponseEntity<Void> redirectToUi(HttpServletRequest request) {
        this.buildFromCurrentContextPath(request);
        String sbUrl = this.contextPath + this.swaggerUiConfigParameters.getUiRootPath() + this.getSwaggerUiUrl();
        UriComponentsBuilder uriBuilder = this.getUriComponentsBuilder(sbUrl);
        request.getParameterMap().forEach((arg_0, arg_1) -> ((UriComponentsBuilder)uriBuilder).queryParam(arg_0, arg_1));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(uriBuilder.build().encode().toUri())).build();
    }

    protected Map<String, Object> openapiJson(HttpServletRequest request) {
        this.buildFromCurrentContextPath(request);
        return this.swaggerUiConfigParameters.getConfigParameters();
    }

    protected void calculateOauth2RedirectUrl(UriComponentsBuilder uriComponentsBuilder) {
        if (StringUtils.isBlank((CharSequence)this.swaggerUiConfig.getOauth2RedirectUrl()) || !this.swaggerUiConfigParameters.isValidUrl(this.swaggerUiConfig.getOauth2RedirectUrl())) {
            this.swaggerUiConfigParameters.setOauth2RedirectUrl(uriComponentsBuilder.path(this.swaggerUiConfigParameters.getUiRootPath()).path(this.getOauth2RedirectUrl()).build().toString());
        }
    }

    void buildFromCurrentContextPath(HttpServletRequest request) {
        super.init();
        this.contextPath = request.getContextPath();
        this.buildConfigUrl((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentContextPath());
    }
}

