/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import java.net.URI;
import java.util.Map;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.ui.AbstractSwaggerWelcome;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public abstract class SwaggerWelcomeCommon
extends AbstractSwaggerWelcome {
    protected String webJarsPrefixUrl;

    protected SwaggerWelcomeCommon(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties) {
        super(swaggerUiConfig, springDocConfigProperties);
        this.webJarsPrefixUrl = springDocConfigProperties.getWebjars().getPrefix();
    }

    protected Mono<Void> redirectToUi(ServerHttpRequest request, ServerHttpResponse response) {
        SwaggerUiConfigParameters swaggerUiConfigParameters = new SwaggerUiConfigParameters(this.swaggerUiConfig);
        this.buildFromCurrentContextPath(swaggerUiConfigParameters, request);
        String sbUrl = this.buildUrl(swaggerUiConfigParameters.getContextPath(), swaggerUiConfigParameters.getUiRootPath() + this.springDocConfigProperties.getWebjars().getPrefix() + this.getSwaggerUiUrl());
        UriComponentsBuilder uriBuilder = this.getUriComponentsBuilder(swaggerUiConfigParameters, sbUrl);
        response.setStatusCode((HttpStatusCode)HttpStatus.FOUND);
        response.getHeaders().setLocation(URI.create(uriBuilder.build().encode().toString()));
        return response.setComplete();
    }

    protected Map<String, Object> getSwaggerUiConfig(ServerHttpRequest request) {
        SwaggerUiConfigParameters swaggerUiConfigParameters = new SwaggerUiConfigParameters(this.swaggerUiConfig);
        this.buildFromCurrentContextPath(swaggerUiConfigParameters, request);
        return swaggerUiConfigParameters.getConfigParameters();
    }

    void buildFromCurrentContextPath(SwaggerUiConfigParameters swaggerUiConfigParameters, ServerHttpRequest request) {
        super.init(swaggerUiConfigParameters);
        swaggerUiConfigParameters.setContextPath(request.getPath().contextPath().value());
        String url = UriComponentsBuilder.fromHttpRequest((HttpRequest)request).toUriString();
        if (!"/".equals(request.getPath().toString())) {
            url = url.replace(request.getPath().toString(), "");
        }
        this.buildConfigUrl(swaggerUiConfigParameters, UriComponentsBuilder.fromUriString((String)url));
    }
}

