/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import io.swagger.v3.oas.annotations.Operation;
import java.util.Map;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.webflux.ui.SwaggerWelcomeCommon;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@ControllerEndpoint(id="swagger-ui")
public class SwaggerWelcomeActuator
extends SwaggerWelcomeCommon {
    private static final String SWAGGER_CONFIG_ACTUATOR_URL = "/swagger-config";
    private final WebEndpointProperties webEndpointProperties;

    public SwaggerWelcomeActuator(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, WebEndpointProperties webEndpointProperties) {
        super(swaggerUiConfig, springDocConfigProperties);
        this.webEndpointProperties = webEndpointProperties;
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"/"})
    public Mono<Void> redirectToUi(ServerWebExchange exchange) {
        return super.redirectToUi(exchange);
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"/swagger-config"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> getSwaggerUiConfig(ServerWebExchange exchange) {
        return super.getSwaggerUiConfig(exchange);
    }

    @Override
    protected void calculateUiRootPath(SwaggerUiConfigParameters swaggerUiConfigParameters, StringBuilder ... sbUrls) {
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(this.webEndpointProperties.getBasePath());
        this.calculateUiRootCommon(swaggerUiConfigParameters, sbUrl, sbUrls);
    }

    protected void buildApiDocUrl(SwaggerUiConfigParameters swaggerUiConfigParameters) {
        swaggerUiConfigParameters.setApiDocsUrl(this.buildUrl(swaggerUiConfigParameters.getContextPath() + this.webEndpointProperties.getBasePath(), "openapi"));
    }

    protected String buildUrlWithContextPath(SwaggerUiConfigParameters swaggerUiConfigParameters, String swaggerUiUrl) {
        return this.buildUrl(swaggerUiConfigParameters.getContextPath() + this.webEndpointProperties.getBasePath(), swaggerUiUrl);
    }

    protected void buildSwaggerConfigUrl(SwaggerUiConfigParameters swaggerUiConfigParameters) {
        swaggerUiConfigParameters.setConfigUrl(swaggerUiConfigParameters.getContextPath() + this.webEndpointProperties.getBasePath() + "/swagger-ui/swagger-config");
    }
}

