/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.ui.AbstractSwaggerConfigurer;
import org.springdoc.webflux.ui.SwaggerIndexTransformer;
import org.springdoc.webflux.ui.SwaggerResourceResolver;
import org.springdoc.webflux.ui.SwaggerWelcomeCommon;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxProperties;
import org.springframework.cache.Cache;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.http.CacheControl;
import org.springframework.web.reactive.config.ResourceChainRegistration;
import org.springframework.web.reactive.config.ResourceHandlerRegistration;
import org.springframework.web.reactive.config.ResourceHandlerRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.resource.CachingResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolver;
import org.springframework.web.reactive.resource.ResourceTransformer;

public class SwaggerWebFluxConfigurer
extends AbstractSwaggerConfigurer
implements WebFluxConfigurer {
    private final SwaggerIndexTransformer swaggerIndexTransformer;
    private final SwaggerResourceResolver swaggerResourceResolver;
    private final SwaggerUiConfigProperties swaggerUiConfigProperties;
    private final WebFluxProperties springWebFluxProperties;
    private final SwaggerWelcomeCommon swaggerWelcomeCommon;
    private Cache cache;

    public SwaggerWebFluxConfigurer(SwaggerUiConfigProperties swaggerUiConfigProperties, WebProperties springWebProperties, WebFluxProperties springWebFluxProperties, SwaggerIndexTransformer swaggerIndexTransformer, SwaggerResourceResolver swaggerResourceResolver, SwaggerWelcomeCommon swaggerWelcomeCommon) {
        super(swaggerUiConfigProperties, springWebProperties);
        this.swaggerIndexTransformer = swaggerIndexTransformer;
        this.swaggerResourceResolver = swaggerResourceResolver;
        this.swaggerUiConfigProperties = swaggerUiConfigProperties;
        this.springWebFluxProperties = springWebFluxProperties;
        this.swaggerWelcomeCommon = swaggerWelcomeCommon;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        this.addSwaggerResourceHandlers(registry, this.getSwaggerHandlerConfigs());
        this.addSwaggerResourceHandlers(registry, this.getSwaggerWebjarHandlerConfigs());
    }

    protected void addSwaggerResourceHandlers(ResourceHandlerRegistry registry, AbstractSwaggerConfigurer.SwaggerResourceHandlerConfig ... handlerConfigs) {
        for (AbstractSwaggerConfigurer.SwaggerResourceHandlerConfig handlerConfig : handlerConfigs) {
            this.addSwaggerResourceHandler(registry, handlerConfig);
        }
    }

    protected void addSwaggerResourceHandler(ResourceHandlerRegistry registry, AbstractSwaggerConfigurer.SwaggerResourceHandlerConfig handlerConfig) {
        ResourceChainRegistration chainRegistration;
        ResourceHandlerRegistration handlerRegistration = registry.addResourceHandler(handlerConfig.patterns());
        handlerRegistration.addResourceLocations(handlerConfig.locations());
        if (handlerConfig.cacheResources()) {
            chainRegistration = handlerRegistration.resourceChain(true, this.getCache());
        } else {
            handlerRegistration.setUseLastModified(false);
            handlerRegistration.setCacheControl(CacheControl.noStore());
            chainRegistration = handlerRegistration.resourceChain(false);
            chainRegistration.addResolver((ResourceResolver)new CachingResourceResolver(this.getCache()));
        }
        chainRegistration.addResolver((ResourceResolver)this.swaggerResourceResolver);
        chainRegistration.addTransformer((ResourceTransformer)this.swaggerIndexTransformer);
    }

    protected String getUiRootPath() {
        SwaggerUiConfigParameters swaggerUiConfigParameters = new SwaggerUiConfigParameters(this.swaggerUiConfigProperties);
        this.swaggerWelcomeCommon.calculateUiRootPath(swaggerUiConfigParameters, new StringBuilder[0]);
        return swaggerUiConfigParameters.getUiRootPath();
    }

    protected String getWebjarsPathPattern() {
        return this.springWebFluxProperties.getWebjarsPathPattern();
    }

    protected Cache getCache() {
        if (this.cache == null) {
            this.cache = new ConcurrentMapCache("swagger-resource-chain-cache");
        }
        return this.cache;
    }
}

