/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import java.util.List;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.ui.AbstractSwaggerResourceResolver;
import org.springframework.core.io.Resource;
import org.springframework.web.reactive.resource.ResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SwaggerResourceResolver
extends AbstractSwaggerResourceResolver
implements ResourceResolver {
    public SwaggerResourceResolver(SwaggerUiConfigProperties swaggerUiConfigProperties) {
        super(swaggerUiConfigProperties);
    }

    public Mono<Resource> resolveResource(ServerWebExchange exchange, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        String webJarResourcePath;
        Mono resolved = chain.resolveResource(exchange, requestPath, locations);
        if (!Mono.empty().equals(resolved) && (webJarResourcePath = this.findWebJarResourcePath(requestPath)) != null) {
            return chain.resolveResource(exchange, webJarResourcePath, locations);
        }
        return resolved;
    }

    public Mono<String> resolveUrlPath(String resourcePath, List<? extends Resource> locations, ResourceResolverChain chain) {
        String webJarResourcePath;
        Mono path = chain.resolveUrlPath(resourcePath, locations);
        if (!Mono.empty().equals(path) && (webJarResourcePath = this.findWebJarResourcePath(resourcePath)) != null) {
            return chain.resolveUrlPath(webJarResourcePath, locations);
        }
        return path;
    }
}

