/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.oas.annotations.Operation;
import java.net.URI;
import java.util.Locale;
import org.springdoc.core.customizers.SpringDocCustomizers;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.SpringDocProviders;
import org.springdoc.core.service.AbstractRequestService;
import org.springdoc.core.service.GenericResponseService;
import org.springdoc.core.service.OpenAPIService;
import org.springdoc.core.service.OperationService;
import org.springdoc.webflux.api.OpenApiResource;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.bind.annotation.GetMapping;
import reactor.core.publisher.Mono;

@RestControllerEndpoint(id="openapi")
@ConditionalOnProperty(name={"springdoc.enable-default-api-docs"}, havingValue="true", matchIfMissing=true)
public class OpenApiActuatorResource
extends OpenApiResource {
    public OpenApiActuatorResource(String groupName, ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders, SpringDocCustomizers springDocCustomizers) {
        super(groupName, openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, springDocConfigProperties, springDocProviders, springDocCustomizers);
    }

    public OpenApiActuatorResource(ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders, SpringDocCustomizers springDocCustomizers) {
        super(openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, springDocConfigProperties, springDocProviders, springDocCustomizers);
    }

    @Operation(hidden=true)
    @GetMapping(value={"/"}, produces={"application/json"})
    public Mono<byte[]> openapiJson(ServerHttpRequest serverHttpRequest, Locale locale) throws JsonProcessingException {
        return super.openapiJson(serverHttpRequest, "", locale);
    }

    @Operation(hidden=true)
    @GetMapping(value={"/yaml"}, produces={"application/vnd.oai.openapi"})
    public Mono<byte[]> openapiYaml(ServerHttpRequest serverHttpRequest, Locale locale) throws JsonProcessingException {
        return super.openapiYaml(serverHttpRequest, "yaml", locale);
    }

    @Override
    protected String calculateServerUrl(ServerHttpRequest serverHttpRequest, String apiDocsUrl, Locale locale) {
        super.initOpenAPIBuilder(locale);
        URI uri = this.getActuatorURI(serverHttpRequest.getURI().getScheme(), serverHttpRequest.getURI().getHost());
        return this.openAPIService.calculateServerBaseUrl(uri.toString(), (HttpRequest)serverHttpRequest);
    }

    @Override
    protected String getServerUrl(ServerHttpRequest serverHttpRequest, String apiDocsUrl) {
        URI uri = serverHttpRequest.getURI();
        return this.getActuatorURI(uri.getScheme(), uri.getHost()).toString();
    }
}

