/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.utils;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Negative;
import jakarta.validation.constraints.NegativeOrZero;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springframework.core.KotlinDetector;
import org.springframework.lang.Nullable;

public class SchemaUtils {
    public static final Boolean JAVA_FIELD_NULLABLE_DEFAULT = true;
    private static final Set<Class<?>> OPTIONAL_TYPES = new HashSet();
    public static final List<String> ANNOTATIONS_FOR_REQUIRED;

    private SchemaUtils() {
    }

    public static boolean swaggerVisible(@Nullable Schema schema, @Nullable Parameter parameter) {
        if (parameter != null) {
            return !parameter.hidden();
        }
        if (schema != null) {
            return !schema.hidden();
        }
        return true;
    }

    @Nullable
    public static Boolean swaggerRequired(@Nullable Schema schema, @Nullable Parameter parameter) {
        if (parameter != null && parameter.required()) {
            return true;
        }
        if (schema != null) {
            if (schema.required() || schema.requiredMode() == Schema.RequiredMode.REQUIRED) {
                return true;
            }
            if (schema.requiredMode() == Schema.RequiredMode.NOT_REQUIRED) {
                return false;
            }
        }
        return null;
    }

    public static boolean hasNotNullAnnotation(Collection<String> annotationSimpleNames) {
        return ANNOTATIONS_FOR_REQUIRED.stream().anyMatch(annotationSimpleNames::contains);
    }

    public static boolean annotatedNotNull(List<Annotation> annotations) {
        Collection annotationSimpleNames = annotations.stream().map(annotation -> annotation.annotationType().getSimpleName()).collect(Collectors.toSet());
        return ANNOTATIONS_FOR_REQUIRED.stream().anyMatch(annotationSimpleNames::contains);
    }

    public static boolean fieldNullable(Field field) {
        KProperty kotlinProperty;
        if (OPTIONAL_TYPES.stream().anyMatch(c -> c.isAssignableFrom(field.getType()))) {
            return true;
        }
        if (KotlinDetector.isKotlinPresent() && KotlinDetector.isKotlinReflectPresent() && KotlinDetector.isKotlinType(field.getDeclaringClass()) && (kotlinProperty = ReflectJvmMapping.getKotlinProperty((Field)field)) != null) {
            return kotlinProperty.getReturnType().isMarkedNullable();
        }
        return JAVA_FIELD_NULLABLE_DEFAULT;
    }

    public static boolean fieldRequired(Field field, @Nullable Schema schema, @Nullable Parameter parameter) {
        Boolean swaggerRequired = SchemaUtils.swaggerRequired(schema, parameter);
        if (swaggerRequired != null) {
            return swaggerRequired;
        }
        boolean annotatedNotNull = SchemaUtils.annotatedNotNull(Arrays.asList(field.getDeclaredAnnotations()));
        if (annotatedNotNull) {
            return true;
        }
        return !SchemaUtils.fieldNullable(field);
    }

    public static void applyValidationsToSchema(io.swagger.v3.oas.models.media.Schema<?> schema, List<Annotation> annotations, String openapiVersion) {
        String specVersion;
        annotations.forEach(anno -> {
            String annotationName = anno.annotationType().getSimpleName();
            if (annotationName.equals(Positive.class.getSimpleName())) {
                if (SpringDocConfigProperties.ApiDocs.OpenApiVersion.OPENAPI_3_1.getVersion().equals(openapiVersion)) {
                    schema.setExclusiveMinimumValue(BigDecimal.ZERO);
                } else {
                    schema.setMinimum(BigDecimal.ZERO);
                    schema.setExclusiveMinimum(Boolean.valueOf(true));
                }
            }
            if (annotationName.equals(PositiveOrZero.class.getSimpleName())) {
                schema.setMinimum(BigDecimal.ZERO);
            }
            if (annotationName.equals(NegativeOrZero.class.getSimpleName())) {
                schema.setMaximum(BigDecimal.ZERO);
            }
            if (annotationName.equals(Negative.class.getSimpleName())) {
                if (SpringDocConfigProperties.ApiDocs.OpenApiVersion.OPENAPI_3_1.getVersion().equals(openapiVersion)) {
                    schema.setExclusiveMaximumValue(BigDecimal.ZERO);
                } else {
                    schema.setMaximum(BigDecimal.ZERO);
                    schema.setExclusiveMaximum(Boolean.valueOf(true));
                }
            }
            if (annotationName.equals(Min.class.getSimpleName())) {
                schema.setMinimum(BigDecimal.valueOf(((Min)anno).value()));
            }
            if (annotationName.equals(Max.class.getSimpleName())) {
                schema.setMaximum(BigDecimal.valueOf(((Max)anno).value()));
            }
            if (annotationName.equals(DecimalMin.class.getSimpleName())) {
                DecimalMin min = (DecimalMin)anno;
                if (min.inclusive()) {
                    schema.setMinimum(BigDecimal.valueOf(Double.parseDouble(min.value())));
                } else {
                    schema.setExclusiveMinimum(Boolean.valueOf(true));
                }
            }
            if (annotationName.equals(DecimalMax.class.getSimpleName())) {
                DecimalMax max = (DecimalMax)anno;
                if (max.inclusive()) {
                    schema.setMaximum(BigDecimal.valueOf(Double.parseDouble(max.value())));
                } else {
                    schema.setExclusiveMaximum(Boolean.valueOf(true));
                }
            }
            if (annotationName.equals(Size.class.getSimpleName())) {
                String type = schema.getType();
                if (type == null && schema.getTypes() != null && schema.getTypes().size() == 1) {
                    type = (String)schema.getTypes().iterator().next();
                }
                if ("array".equals(type)) {
                    schema.setMinItems(Integer.valueOf(((Size)anno).min()));
                    schema.setMaxItems(Integer.valueOf(((Size)anno).max()));
                } else if ("string".equals(type)) {
                    schema.setMinLength(Integer.valueOf(((Size)anno).min()));
                    schema.setMaxLength(Integer.valueOf(((Size)anno).max()));
                }
            }
            if (annotationName.equals(Pattern.class.getSimpleName())) {
                schema.setPattern(((Pattern)anno).regexp());
            }
        });
        if (SchemaUtils.annotatedNotNull(annotations) && !"V30".equals(specVersion = schema.getSpecVersion().name())) {
            schema.setNullable(Boolean.valueOf(false));
        }
    }

    static {
        OPTIONAL_TYPES.add(Optional.class);
        OPTIONAL_TYPES.add(OptionalInt.class);
        OPTIONAL_TYPES.add(OptionalLong.class);
        OPTIONAL_TYPES.add(OptionalDouble.class);
        ANNOTATIONS_FOR_REQUIRED = Arrays.asList("NotNull", "NonNull", "NotBlank", "NotEmpty");
    }
}

