/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.extractor;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.annotations.ParameterObject;
import org.springdoc.core.converters.AdditionalModelsConverter;
import org.springdoc.core.customizers.DelegatingMethodParameterCustomizer;
import org.springdoc.core.extractor.MethodParameterPojoExtractor;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class DelegatingMethodParameter
extends MethodParameter {
    private MethodParameter delegate;
    private Annotation[] additionalParameterAnnotations;
    private String parameterName;
    private boolean isParameterObject;
    private boolean isNotRequired;
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatingMethodParameter.class);

    DelegatingMethodParameter(MethodParameter delegate, String parameterName, Annotation[] additionalParameterAnnotations, boolean isParameterObject, boolean isNotRequired) {
        super(delegate);
        this.delegate = delegate;
        this.additionalParameterAnnotations = additionalParameterAnnotations;
        this.parameterName = parameterName;
        this.isParameterObject = isParameterObject;
        this.isNotRequired = isNotRequired;
    }

    public static MethodParameter[] customize(String[] pNames, MethodParameter[] parameters, Optional<DelegatingMethodParameterCustomizer> optionalDelegatingMethodParameterCustomizer) {
        ArrayList<DelegatingMethodParameter> explodedParameters = new ArrayList<DelegatingMethodParameter>();
        for (int i = 0; i < parameters.length; ++i) {
            MethodParameter p = parameters[i];
            Class paramClass = AdditionalModelsConverter.getParameterObjectReplacement(p.getParameterType());
            if (!MethodParameterPojoExtractor.isSimpleType(paramClass) && (p.hasParameterAnnotation(ParameterObject.class) || AnnotatedElementUtils.isAnnotated((AnnotatedElement)paramClass, ParameterObject.class))) {
                MethodParameterPojoExtractor.extractFrom(paramClass).forEach(methodParameter -> {
                    optionalDelegatingMethodParameterCustomizer.ifPresent(customizer -> customizer.customize(p, (MethodParameter)methodParameter));
                    explodedParameters.add((DelegatingMethodParameter)((Object)methodParameter));
                });
                continue;
            }
            String name = pNames != null ? pNames[i] : p.getParameterName();
            explodedParameters.add(new DelegatingMethodParameter(p, name, null, false, false));
        }
        return explodedParameters.toArray(new MethodParameter[0]);
    }

    @NonNull
    public Annotation[] getParameterAnnotations() {
        return (Annotation[])ArrayUtils.addAll((Object[])this.delegate.getParameterAnnotations(), (Object[])this.additionalParameterAnnotations);
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public Method getMethod() {
        return this.delegate.getMethod();
    }

    public Constructor<?> getConstructor() {
        return this.delegate.getConstructor();
    }

    public Class<?> getDeclaringClass() {
        return this.delegate.getDeclaringClass();
    }

    public Member getMember() {
        return this.delegate.getMember();
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.delegate.getAnnotatedElement();
    }

    public Executable getExecutable() {
        return this.delegate.getExecutable();
    }

    public MethodParameter withContainingClass(Class<?> containingClass) {
        return this.delegate.withContainingClass(containingClass);
    }

    public Class<?> getContainingClass() {
        return this.delegate.getContainingClass();
    }

    public Class<?> getParameterType() {
        return this.delegate.getParameterType();
    }

    public Type getGenericParameterType() {
        return this.delegate.getGenericParameterType();
    }

    public Class<?> getNestedParameterType() {
        return this.delegate.getNestedParameterType();
    }

    public Type getNestedGenericParameterType() {
        return this.delegate.getNestedGenericParameterType();
    }

    public void initParameterNameDiscovery(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.delegate.initParameterNameDiscovery(parameterNameDiscoverer);
    }

    public boolean isNotRequired() {
        return this.isNotRequired;
    }

    public void setNotRequired(boolean notRequired) {
        this.isNotRequired = notRequired;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DelegatingMethodParameter that = (DelegatingMethodParameter)((Object)o);
        return Objects.equals(this.delegate, that.delegate) && Arrays.equals(this.additionalParameterAnnotations, that.additionalParameterAnnotations) && Objects.equals(this.parameterName, that.parameterName);
    }

    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.delegate, this.parameterName);
        result = 31 * result + Arrays.hashCode(this.additionalParameterAnnotations);
        return result;
    }

    public boolean isParameterObject() {
        return this.isParameterObject;
    }

    public static MethodParameter changeContainingClass(MethodParameter methodParameter, @Nullable Class<?> containingClass) {
        MethodParameter result = methodParameter.clone();
        try {
            Field containingClassField = FieldUtils.getDeclaredField(result.getClass(), (String)"containingClass", (boolean)true);
            containingClassField.set(result, containingClass);
            Field parameterTypeField = FieldUtils.getDeclaredField(result.getClass(), (String)"parameterType", (boolean)true);
            parameterTypeField.set(result, null);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn(e.getMessage());
        }
        return result;
    }
}

