/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.configuration;

import io.swagger.v3.core.util.Json;
import java.util.Optional;
import org.springdoc.core.converters.CollectionModelContentConverter;
import org.springdoc.core.converters.RepresentationModelLinksOASMixin;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springdoc.core.customizers.OpenApiHateoasLinksCustomizer;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.HateoasHalProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.hateoas.HateoasProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.LinkRelationProvider;

@Lazy(value=false)
@Configuration(proxyBeanMethods=false)
@ConditionalOnExpression(value="${springdoc.api-docs.enabled:true} and ${springdoc.enable-hateoas:true}")
@ConditionalOnClass(value={LinkRelationProvider.class})
@ConditionalOnWebApplication
public class SpringDocHateoasConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    HateoasHalProvider hateoasHalProvider(Optional<HateoasProperties> hateoasPropertiesOptional) {
        return new HateoasHalProvider(hateoasPropertiesOptional);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    CollectionModelContentConverter collectionModelContentConverter(HateoasHalProvider halProvider, LinkRelationProvider linkRelationProvider) {
        return halProvider.isHalEnabled() ? new CollectionModelContentConverter(linkRelationProvider) : null;
    }

    @Bean(value={"linksSchemaCustomiser"})
    @ConditionalOnMissingBean
    @Lazy(value=false)
    OpenApiCustomizer linksSchemaCustomiser(HateoasHalProvider halProvider, SpringDocConfigProperties springDocConfigProperties) {
        if (!halProvider.isHalEnabled()) {
            return openApi -> {};
        }
        Json.mapper().addMixIn(RepresentationModel.class, RepresentationModelLinksOASMixin.class);
        return new OpenApiHateoasLinksCustomizer(springDocConfigProperties);
    }
}

