/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.data.rest.core;

import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.MethodAttributes;
import org.springdoc.core.SpringDocAnnotationsUtils;
import org.springdoc.data.rest.core.ControllerType;
import org.springdoc.data.rest.core.DataRestRepository;
import org.springdoc.data.rest.core.DataRestRequestService;
import org.springdoc.data.rest.core.DataRestResponseService;
import org.springdoc.data.rest.core.DataRestTagsService;
import org.springframework.core.MethodParameter;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.ParameterMetadata;
import org.springframework.data.rest.core.mapping.ParametersMetadata;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.TypedResourceDescription;
import org.springframework.data.rest.webmvc.support.DefaultedPageable;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;

public class DataRestOperationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataRestOperationService.class);
    private static final String STRING_SEPARATOR = "-";
    private DataRestRequestService dataRestRequestService;
    private DataRestTagsService tagsBuilder;
    private DataRestResponseService dataRestResponseService;

    public DataRestOperationService(DataRestRequestService dataRestRequestService, DataRestTagsService tagsBuilder, DataRestResponseService dataRestResponseService) {
        this.dataRestRequestService = dataRestRequestService;
        this.tagsBuilder = tagsBuilder;
        this.dataRestResponseService = dataRestResponseService;
    }

    public Operation buildOperation(HandlerMethod handlerMethod, DataRestRepository dataRestRepository, OpenAPI openAPI, RequestMethod requestMethod, String operationPath, MethodAttributes methodAttributes, ResourceMetadata resourceMetadata, MethodResourceMapping methodResourceMapping, ControllerType controllerType) {
        Operation operation = null;
        if (ControllerType.ENTITY.equals((Object)controllerType) || ControllerType.PROPERTY.equals((Object)controllerType) || ControllerType.SCHEMA.equals((Object)controllerType)) {
            operation = this.buildEntityOperation(handlerMethod, dataRestRepository, openAPI, requestMethod, operationPath, methodAttributes, resourceMetadata);
        } else if (ControllerType.SEARCH.equals((Object)controllerType)) {
            operation = this.buildSearchOperation(handlerMethod, dataRestRepository, openAPI, requestMethod, methodAttributes, methodResourceMapping);
        }
        return operation;
    }

    private Operation buildEntityOperation(HandlerMethod handlerMethod, DataRestRepository dataRestRepository, OpenAPI openAPI, RequestMethod requestMethod, String operationPath, MethodAttributes methodAttributes, ResourceMetadata resourceMetadata) {
        Class<?> domainType = null;
        if (dataRestRepository != null) {
            domainType = dataRestRepository.getDomainType();
        }
        Operation operation = this.initOperation(handlerMethod, domainType, requestMethod);
        this.dataRestRequestService.buildParameters(domainType, openAPI, handlerMethod, requestMethod, methodAttributes, operation, resourceMetadata);
        this.dataRestResponseService.buildEntityResponse(operation, handlerMethod, openAPI, requestMethod, operationPath, domainType, methodAttributes);
        this.tagsBuilder.buildEntityTags(operation, handlerMethod, dataRestRepository);
        if (domainType != null) {
            this.addOperationDescription(operation, requestMethod, domainType.getSimpleName().toLowerCase());
        }
        return operation;
    }

    private Operation buildSearchOperation(HandlerMethod handlerMethod, DataRestRepository dataRestRepository, OpenAPI openAPI, RequestMethod requestMethod, MethodAttributes methodAttributes, MethodResourceMapping methodResourceMapping) {
        Class<?> domainType = dataRestRepository.getDomainType();
        Operation operation = this.initOperation(handlerMethod, domainType, requestMethod);
        ParametersMetadata parameterMetadata = methodResourceMapping.getParametersMetadata();
        for (ParameterMetadata parameterMetadatum : parameterMetadata) {
            Class<String> type;
            String pName = parameterMetadatum.getName();
            ResourceDescription description = parameterMetadatum.getDescription();
            if (!(description instanceof TypedResourceDescription)) continue;
            TypedResourceDescription typedResourceDescription = (TypedResourceDescription)description;
            Field fieldType = FieldUtils.getField(TypedResourceDescription.class, (String)"type", (boolean)true);
            try {
                type = (Class<String>)fieldType.get(typedResourceDescription);
            }
            catch (IllegalAccessException e) {
                LOGGER.warn(e.getMessage());
                type = String.class;
            }
            Schema schema = SpringDocAnnotationsUtils.resolveSchemaFromType(type, (Components)openAPI.getComponents(), null, null);
            Parameter parameter = new Parameter().name(pName).in(ParameterIn.QUERY.toString()).schema(schema);
            operation.addParametersItem(parameter);
        }
        if (methodResourceMapping.isPagingResource()) {
            MethodParameter[] parameters = handlerMethod.getMethodParameters();
            Arrays.stream(parameters).filter(methodParameter -> DefaultedPageable.class.equals((Object)methodParameter.getParameterType())).findAny().ifPresent(methodParameterPage -> this.dataRestRequestService.buildCommonParameters(domainType, openAPI, requestMethod, methodAttributes, operation, new String[]{methodParameterPage.getParameterName()}, new MethodParameter[]{methodParameterPage}));
        }
        this.dataRestResponseService.buildSearchResponse(operation, handlerMethod, openAPI, methodResourceMapping, domainType, methodAttributes);
        this.tagsBuilder.buildSearchTags(operation, handlerMethod, dataRestRepository);
        return operation;
    }

    private Operation initOperation(HandlerMethod handlerMethod, Class<?> domainType, RequestMethod requestMethod) {
        Operation operation = new Operation();
        StringBuilder operationIdBuilder = new StringBuilder();
        operationIdBuilder.append(handlerMethod.getMethod().getName());
        if (domainType != null) {
            operationIdBuilder.append(STRING_SEPARATOR).append(domainType.getSimpleName().toLowerCase()).append(STRING_SEPARATOR).append(requestMethod.toString().toLowerCase());
        }
        operation.setOperationId(operationIdBuilder.toString());
        return operation;
    }

    private void addOperationDescription(Operation operation, RequestMethod requestMethod, String entity) {
        switch (requestMethod) {
            case GET: {
                operation.setDescription("get-" + entity);
                break;
            }
            case POST: {
                operation.setDescription("create-" + entity);
                break;
            }
            case DELETE: {
                operation.setDescription("delete-" + entity);
                break;
            }
            case PUT: {
                operation.setDescription("update-" + entity);
                break;
            }
            case PATCH: {
                operation.setDescription("patch-" + entity);
                break;
            }
            default: {
                throw new IllegalArgumentException(requestMethod.name());
            }
        }
    }
}

