/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.api;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.filter.SpecFilter;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.callbacks.Callback;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.AbstractRequestBuilder;
import org.springdoc.core.GenericParameterBuilder;
import org.springdoc.core.GenericResponseBuilder;
import org.springdoc.core.MethodAttributes;
import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.core.OperationBuilder;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.annotations.RouterOperation;
import org.springdoc.core.annotations.RouterOperations;
import org.springdoc.core.converters.SchemaPropertyDeprecatingConverter;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.core.models.RouterFunctionData;
import org.springdoc.core.visitor.AbstractRouterFunctionVisitor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;

public abstract class AbstractOpenApiResource
extends SpecFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOpenApiResource.class);
    private static final List<Class<?>> ADDITIONAL_REST_CONTROLLERS = new ArrayList();
    private static final List<Class<?>> HIDDEN_REST_CONTROLLERS = new ArrayList();
    protected final OpenAPIBuilder openAPIBuilder;
    protected final SpringDocConfigProperties springDocConfigProperties;
    private final AbstractRequestBuilder requestBuilder;
    private final GenericResponseBuilder responseBuilder;
    private final OperationBuilder operationParser;
    private final Optional<List<OpenApiCustomiser>> openApiCustomisers;
    private final Optional<List<OperationCustomizer>> operationCustomizers;
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private final String groupName;

    protected AbstractOpenApiResource(String groupName, OpenAPIBuilder openAPIBuilder, AbstractRequestBuilder requestBuilder, GenericResponseBuilder responseBuilder, OperationBuilder operationParser, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<OpenApiCustomiser>> openApiCustomisers, SpringDocConfigProperties springDocConfigProperties) {
        this.groupName = Objects.requireNonNull(groupName, "groupName");
        this.openAPIBuilder = openAPIBuilder;
        this.requestBuilder = requestBuilder;
        this.responseBuilder = responseBuilder;
        this.operationParser = operationParser;
        this.openApiCustomisers = openApiCustomisers;
        this.springDocConfigProperties = springDocConfigProperties;
        if (operationCustomizers.isPresent()) {
            operationCustomizers.get().removeIf(Objects::isNull);
        }
        this.operationCustomizers = operationCustomizers;
    }

    public static void addRestControllers(Class<?> ... classes) {
        ADDITIONAL_REST_CONTROLLERS.addAll(Arrays.asList(classes));
    }

    public static void addHiddenRestControllers(Class<?> ... classes) {
        HIDDEN_REST_CONTROLLERS.addAll(Arrays.asList(classes));
    }

    protected synchronized OpenAPI getOpenApi() {
        OpenAPI openApi;
        if (this.openAPIBuilder.getCachedOpenAPI() == null || this.springDocConfigProperties.isCacheDisabled()) {
            Instant start = Instant.now();
            this.openAPIBuilder.build();
            Map<String, Object> mappingsMap = this.openAPIBuilder.getMappingsMap().entrySet().stream().filter(controller -> AnnotationUtils.findAnnotation(controller.getValue().getClass(), Hidden.class) == null).filter(controller -> !this.isHiddenRestControllers(controller.getValue().getClass())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
            Map<String, Object> findControllerAdvice = this.openAPIBuilder.getControllerAdviceMap();
            openApi = this.openAPIBuilder.getCalculatedOpenAPI();
            this.responseBuilder.buildGenericResponse(openApi.getComponents(), findControllerAdvice);
            this.getPaths(mappingsMap);
            this.openApiCustomisers.ifPresent(apiCustomisers -> apiCustomisers.forEach(openApiCustomiser -> openApiCustomiser.customise(openApi)));
            if (this.springDocConfigProperties.isRemoveBrokenReferenceDefinitions()) {
                this.removeBrokenReferenceDefinitions(openApi);
            }
            this.openAPIBuilder.setCachedOpenAPI(openApi);
            this.openAPIBuilder.resetCalculatedOpenAPI();
            LOGGER.info("Init duration for springdoc-openapi is: {} ms", (Object)Duration.between(start, Instant.now()).toMillis());
        } else {
            openApi = this.openAPIBuilder.calculateCachedOpenAPI();
        }
        return openApi;
    }

    protected abstract void getPaths(Map<String, Object> var1);

    protected void calculatePath(HandlerMethod handlerMethod, org.springdoc.core.models.RouterOperation routerOperation) {
        String operationPath = routerOperation.getPath();
        HashSet<RequestMethod> requestMethods = new HashSet<RequestMethod>(Arrays.asList(routerOperation.getMethods()));
        io.swagger.v3.oas.annotations.Operation apiOperation = routerOperation.getOperation();
        String[] methodConsumes = routerOperation.getConsumes();
        String[] methodProduces = routerOperation.getProduces();
        String[] headers = routerOperation.getHeaders();
        Map<String, String> queryParams = routerOperation.getQueryParams();
        OpenAPI openAPI = this.openAPIBuilder.getCalculatedOpenAPI();
        Components components = openAPI.getComponents();
        Paths paths = openAPI.getPaths();
        Map operationMap = null;
        if (paths.containsKey((Object)operationPath)) {
            PathItem pathItem = (PathItem)paths.get((Object)operationPath);
            operationMap = pathItem.readOperationsMap();
        }
        for (RequestMethod requestMethod : requestMethods) {
            Operation operation;
            Operation existingOperation = this.getExistingOperation(operationMap, requestMethod);
            Method method = handlerMethod.getMethod();
            if (this.operationParser.isHidden(method)) continue;
            RequestMapping reqMappingClass = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)handlerMethod.getBeanType(), RequestMapping.class);
            MethodAttributes methodAttributes = new MethodAttributes(this.springDocConfigProperties.getDefaultConsumesMediaType(), this.springDocConfigProperties.getDefaultProducesMediaType(), methodConsumes, methodProduces, headers);
            methodAttributes.setMethodOverloaded(existingOperation != null);
            if (reqMappingClass != null) {
                methodAttributes.setClassConsumes(reqMappingClass.consumes());
                methodAttributes.setClassProduces(reqMappingClass.produces());
            }
            methodAttributes.calculateConsumesProduces(method);
            Operation operation2 = operation = existingOperation != null ? existingOperation : new Operation();
            if (SchemaPropertyDeprecatingConverter.isDeprecated(method)) {
                operation.setDeprecated(Boolean.valueOf(true));
            }
            if (apiOperation == null || StringUtils.isBlank((CharSequence)apiOperation.operationId())) {
                apiOperation = (io.swagger.v3.oas.annotations.Operation)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, io.swagger.v3.oas.annotations.Operation.class);
            }
            this.calculateJsonView(apiOperation, methodAttributes, method);
            if (apiOperation != null) {
                openAPI = this.operationParser.parse(apiOperation, operation, openAPI, methodAttributes);
            }
            this.fillParametersList(operation, queryParams, methodAttributes);
            operation = this.openAPIBuilder.buildTags(handlerMethod, operation, openAPI);
            RequestBody requestBodyDoc = (RequestBody)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestBody.class);
            this.requestBuilder.getRequestBodyBuilder().buildRequestBodyFromDoc(requestBodyDoc, methodAttributes, components, methodAttributes.getJsonViewAnnotationForRequestBody()).ifPresent(arg_0 -> ((Operation)operation).setRequestBody(arg_0));
            operation = this.requestBuilder.build(handlerMethod, requestMethod, operation, methodAttributes, openAPI);
            ApiResponses apiResponses = this.responseBuilder.build(components, handlerMethod, operation, methodAttributes);
            operation.setResponses(apiResponses);
            Set apiCallbacks = AnnotatedElementUtils.findMergedRepeatableAnnotations((AnnotatedElement)method, Callback.class);
            if (!CollectionUtils.isEmpty((Collection)apiCallbacks)) {
                this.operationParser.buildCallbacks(apiCallbacks, openAPI, methodAttributes).ifPresent(arg_0 -> ((Operation)operation).setCallbacks(arg_0));
            }
            this.customiseOperation(operation, handlerMethod);
            PathItem pathItemObject = this.buildPathItem(requestMethod, operation, operationPath, paths);
            paths.addPathItem(operationPath, pathItemObject);
        }
    }

    protected void calculatePath(List<org.springdoc.core.models.RouterOperation> routerOperationList) {
        ApplicationContext applicationContext = this.openAPIBuilder.getContext();
        if (!CollectionUtils.isEmpty(routerOperationList)) {
            for (org.springdoc.core.models.RouterOperation routerOperation : routerOperationList) {
                if (!Void.class.equals(routerOperation.getBeanClass())) {
                    Object handlerBean = applicationContext.getBean(routerOperation.getBeanClass());
                    HandlerMethod handlerMethod = null;
                    if (!StringUtils.isNotBlank((CharSequence)routerOperation.getBeanMethod())) continue;
                    try {
                        if (ArrayUtils.isEmpty((Object[])routerOperation.getParameterTypes())) {
                            Optional<Method> methodOptional = Arrays.stream(handlerBean.getClass().getDeclaredMethods()).filter(method -> routerOperation.getBeanMethod().equals(method.getName()) && method.getParameters().length == 0).findAny();
                            if (!methodOptional.isPresent()) {
                                methodOptional = Arrays.stream(handlerBean.getClass().getDeclaredMethods()).filter(method1 -> routerOperation.getBeanMethod().equals(method1.getName())).findAny();
                            }
                            if (methodOptional.isPresent()) {
                                handlerMethod = new HandlerMethod(handlerBean, methodOptional.get());
                            }
                        } else {
                            handlerMethod = new HandlerMethod(handlerBean, routerOperation.getBeanMethod(), (Class[])routerOperation.getParameterTypes());
                        }
                    }
                    catch (NoSuchMethodException e) {
                        LOGGER.error(e.getMessage());
                    }
                    if (handlerMethod == null || !this.isPackageToScan(handlerMethod.getBeanType().getPackage()) || !this.isPathToMatch(routerOperation.getPath())) continue;
                    this.calculatePath(handlerMethod, routerOperation);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)routerOperation.getOperation().operationId()) || !this.isPathToMatch(routerOperation.getPath())) continue;
                this.calculatePath(routerOperation);
            }
        }
    }

    protected void calculatePath(org.springdoc.core.models.RouterOperation routerOperation) {
        String operationPath = routerOperation.getPath();
        HashSet<RequestMethod> requestMethods = new HashSet<RequestMethod>(Arrays.asList(routerOperation.getMethods()));
        io.swagger.v3.oas.annotations.Operation apiOperation = routerOperation.getOperation();
        String[] methodConsumes = routerOperation.getConsumes();
        String[] methodProduces = routerOperation.getProduces();
        String[] headers = routerOperation.getHeaders();
        Map<String, String> queryParams = routerOperation.getQueryParams();
        OpenAPI openAPI = this.openAPIBuilder.getCalculatedOpenAPI();
        Paths paths = openAPI.getPaths();
        Map operationMap = null;
        if (paths.containsKey((Object)operationPath)) {
            PathItem pathItem = (PathItem)paths.get((Object)operationPath);
            operationMap = pathItem.readOperationsMap();
        }
        for (RequestMethod requestMethod : requestMethods) {
            Operation existingOperation = this.getExistingOperation(operationMap, requestMethod);
            MethodAttributes methodAttributes = new MethodAttributes(this.springDocConfigProperties.getDefaultConsumesMediaType(), this.springDocConfigProperties.getDefaultProducesMediaType(), methodConsumes, methodProduces, headers);
            methodAttributes.setMethodOverloaded(existingOperation != null);
            Operation operation = existingOperation != null ? existingOperation : new Operation();
            openAPI = this.operationParser.parse(apiOperation, operation, openAPI, methodAttributes);
            this.fillParametersList(operation, queryParams, methodAttributes);
            if (!CollectionUtils.isEmpty((Collection)operation.getParameters())) {
                operation.getParameters().forEach(parameter -> {
                    if (parameter.getSchema() == null) {
                        parameter.setSchema((Schema)new StringSchema());
                    }
                    if (parameter.getIn() == null) {
                        parameter.setIn(ParameterIn.QUERY.toString());
                    }
                });
            }
            PathItem pathItemObject = this.buildPathItem(requestMethod, operation, operationPath, paths);
            paths.addPathItem(operationPath, pathItemObject);
        }
    }

    protected void calculatePath(HandlerMethod handlerMethod, String operationPath, Set<RequestMethod> requestMethods) {
        this.calculatePath(handlerMethod, new org.springdoc.core.models.RouterOperation(operationPath, requestMethods.toArray(new RequestMethod[requestMethods.size()])));
    }

    protected void getRouterFunctionPaths(String beanName, AbstractRouterFunctionVisitor routerFunctionVisitor) {
        ArrayList<RouterOperation> routerOperationList = new ArrayList<RouterOperation>();
        ApplicationContext applicationContext = this.openAPIBuilder.getContext();
        RouterOperations routerOperations = (RouterOperations)applicationContext.findAnnotationOnBean(beanName, RouterOperations.class);
        if (routerOperations == null) {
            RouterOperation routerOperation2 = (RouterOperation)applicationContext.findAnnotationOnBean(beanName, RouterOperation.class);
            if (routerOperation2 != null) {
                routerOperationList.add(routerOperation2);
            }
        } else {
            routerOperationList.addAll(Arrays.asList(routerOperations.value()));
        }
        if (routerOperationList.size() == 1) {
            this.calculatePath(routerOperationList.stream().map(routerOperation -> new org.springdoc.core.models.RouterOperation((RouterOperation)routerOperation, routerFunctionVisitor.getRouterFunctionDatas().get(0))).collect(Collectors.toList()));
        } else {
            List<org.springdoc.core.models.RouterOperation> operationList = routerOperationList.stream().map(org.springdoc.core.models.RouterOperation::new).collect(Collectors.toList());
            this.mergeRouters(routerFunctionVisitor.getRouterFunctionDatas(), operationList);
            this.calculatePath(operationList);
        }
    }

    protected boolean isPackageToScan(Package aPackage) {
        Optional<SpringDocConfigProperties.GroupConfig> optionalGroupConfig;
        if (aPackage == null) {
            return true;
        }
        String packageName = aPackage.getName();
        List<String> packagesToScan = this.springDocConfigProperties.getPackagesToScan();
        List<String> packagesToExclude = this.springDocConfigProperties.getPackagesToExclude();
        if (CollectionUtils.isEmpty(packagesToScan) && (optionalGroupConfig = this.springDocConfigProperties.getGroupConfigs().stream().filter(groupConfig -> this.groupName.equals(groupConfig.getGroup())).findAny()).isPresent()) {
            packagesToScan = optionalGroupConfig.get().getPackagesToScan();
        }
        if (CollectionUtils.isEmpty(packagesToExclude) && (optionalGroupConfig = this.springDocConfigProperties.getGroupConfigs().stream().filter(groupConfig -> this.groupName.equals(groupConfig.getGroup())).findAny()).isPresent()) {
            packagesToExclude = optionalGroupConfig.get().getPackagesToExclude();
        }
        boolean include = CollectionUtils.isEmpty(packagesToScan) || packagesToScan.stream().anyMatch(pack -> packageName.equals(pack) || packageName.startsWith(pack + "."));
        boolean exclude = !CollectionUtils.isEmpty(packagesToExclude) && packagesToExclude.stream().anyMatch(pack -> packageName.equals(pack) || packageName.startsWith(pack + "."));
        return include && !exclude;
    }

    protected boolean isPathToMatch(String operationPath) {
        Optional<SpringDocConfigProperties.GroupConfig> optionalGroupConfig;
        List<String> pathsToMatch = this.springDocConfigProperties.getPathsToMatch();
        List<String> pathsToExclude = this.springDocConfigProperties.getPathsToExclude();
        if (CollectionUtils.isEmpty(pathsToMatch) && (optionalGroupConfig = this.springDocConfigProperties.getGroupConfigs().stream().filter(groupConfig -> this.groupName.equals(groupConfig.getGroup())).findAny()).isPresent()) {
            pathsToMatch = optionalGroupConfig.get().getPathsToMatch();
        }
        if (CollectionUtils.isEmpty(pathsToExclude) && (optionalGroupConfig = this.springDocConfigProperties.getGroupConfigs().stream().filter(groupConfig -> this.groupName.equals(groupConfig.getGroup())).findAny()).isPresent()) {
            pathsToExclude = optionalGroupConfig.get().getPathsToExclude();
        }
        boolean include = CollectionUtils.isEmpty(pathsToMatch) || pathsToMatch.stream().anyMatch(pattern -> this.antPathMatcher.match(pattern, operationPath));
        boolean exclude = !CollectionUtils.isEmpty(pathsToExclude) && pathsToExclude.stream().anyMatch(pattern -> this.antPathMatcher.match(pattern, operationPath));
        return include && !exclude;
    }

    protected String decode(String requestURI) {
        try {
            return URLDecoder.decode(requestURI, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            return requestURI;
        }
    }

    protected boolean isAdditionalRestController(Class<?> rawClass) {
        return ADDITIONAL_REST_CONTROLLERS.stream().anyMatch(clazz -> clazz.isAssignableFrom(rawClass));
    }

    protected boolean isHiddenRestControllers(Class<?> rawClass) {
        return HIDDEN_REST_CONTROLLERS.stream().anyMatch(clazz -> clazz.isAssignableFrom(rawClass));
    }

    protected Set getDefaultAllowedHttpMethods() {
        RequestMethod[] allowedRequestMethods = new RequestMethod[]{RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE, RequestMethod.OPTIONS, RequestMethod.HEAD};
        return new HashSet<RequestMethod>(Arrays.asList(allowedRequestMethods));
    }

    protected Operation customiseOperation(Operation operation, HandlerMethod handlerMethod) {
        this.operationCustomizers.ifPresent(customizers -> customizers.forEach(customizer -> customizer.customize(operation, handlerMethod)));
        return operation;
    }

    protected void mergeRouters(List<RouterFunctionData> routerFunctionDatas, List<org.springdoc.core.models.RouterOperation> routerOperationList) {
        for (org.springdoc.core.models.RouterOperation routerOperation : routerOperationList) {
            if (!StringUtils.isNotBlank((CharSequence)routerOperation.getPath())) continue;
            List routerFunctionDataList = routerFunctionDatas.stream().filter(routerFunctionData1 -> routerFunctionData1.getPath().equals(routerOperation.getPath())).collect(Collectors.toList());
            if (routerFunctionDataList.size() == 1) {
                this.fillRouterOperation((RouterFunctionData)routerFunctionDataList.get(0), routerOperation);
                continue;
            }
            if (routerFunctionDataList.size() > 1 && ArrayUtils.isNotEmpty((Object[])routerOperation.getMethods())) {
                routerFunctionDataList = routerFunctionDatas.stream().filter(routerFunctionData1 -> routerFunctionData1.getPath().equals(routerOperation.getPath()) && this.isEqualMethods(routerOperation.getMethods(), routerFunctionData1.getMethods())).collect(Collectors.toList());
                if (routerFunctionDataList.size() == 1) {
                    this.fillRouterOperation((RouterFunctionData)routerFunctionDataList.get(0), routerOperation);
                    continue;
                }
                if (routerFunctionDataList.size() > 1 && ArrayUtils.isNotEmpty((Object[])routerOperation.getProduces())) {
                    routerFunctionDataList = routerFunctionDatas.stream().filter(routerFunctionData1 -> routerFunctionData1.getPath().equals(routerOperation.getPath()) && this.isEqualMethods(routerOperation.getMethods(), routerFunctionData1.getMethods()) && this.isEqualArrays(routerFunctionData1.getProduces(), routerOperation.getProduces())).collect(Collectors.toList());
                    if (routerFunctionDataList.size() == 1) {
                        this.fillRouterOperation((RouterFunctionData)routerFunctionDataList.get(0), routerOperation);
                        continue;
                    }
                    if (routerFunctionDataList.size() <= 1 || !ArrayUtils.isNotEmpty((Object[])routerOperation.getConsumes()) || (routerFunctionDataList = routerFunctionDatas.stream().filter(routerFunctionData1 -> routerFunctionData1.getPath().equals(routerOperation.getPath()) && this.isEqualMethods(routerOperation.getMethods(), routerFunctionData1.getMethods()) && this.isEqualArrays(routerFunctionData1.getProduces(), routerOperation.getProduces()) && this.isEqualArrays(routerFunctionData1.getConsumes(), routerOperation.getConsumes())).collect(Collectors.toList())).size() != 1) continue;
                    this.fillRouterOperation((RouterFunctionData)routerFunctionDataList.get(0), routerOperation);
                    continue;
                }
                if (routerFunctionDataList.size() <= 1 || !ArrayUtils.isNotEmpty((Object[])routerOperation.getConsumes()) || (routerFunctionDataList = routerFunctionDatas.stream().filter(routerFunctionData1 -> routerFunctionData1.getPath().equals(routerOperation.getPath()) && this.isEqualMethods(routerOperation.getMethods(), routerFunctionData1.getMethods()) && this.isEqualArrays(routerFunctionData1.getConsumes(), routerOperation.getConsumes())).collect(Collectors.toList())).size() != 1) continue;
                this.fillRouterOperation((RouterFunctionData)routerFunctionDataList.get(0), routerOperation);
                continue;
            }
            if (routerFunctionDataList.size() > 1 && ArrayUtils.isNotEmpty((Object[])routerOperation.getProduces())) {
                routerFunctionDataList = routerFunctionDatas.stream().filter(routerFunctionData1 -> routerFunctionData1.getPath().equals(routerOperation.getPath()) && this.isEqualArrays(routerFunctionData1.getProduces(), routerOperation.getProduces())).collect(Collectors.toList());
                if (routerFunctionDataList.size() == 1) {
                    this.fillRouterOperation((RouterFunctionData)routerFunctionDataList.get(0), routerOperation);
                    continue;
                }
                if (routerFunctionDataList.size() <= 1 || !ArrayUtils.isNotEmpty((Object[])routerOperation.getConsumes()) || (routerFunctionDataList = routerFunctionDatas.stream().filter(routerFunctionData1 -> routerFunctionData1.getPath().equals(routerOperation.getPath()) && this.isEqualMethods(routerOperation.getMethods(), routerFunctionData1.getMethods()) && this.isEqualArrays(routerFunctionData1.getConsumes(), routerOperation.getConsumes()) && this.isEqualArrays(routerFunctionData1.getProduces(), routerOperation.getProduces())).collect(Collectors.toList())).size() != 1) continue;
                this.fillRouterOperation((RouterFunctionData)routerFunctionDataList.get(0), routerOperation);
                continue;
            }
            if (routerFunctionDataList.size() <= 1 || !ArrayUtils.isNotEmpty((Object[])routerOperation.getConsumes()) || (routerFunctionDataList = routerFunctionDatas.stream().filter(routerFunctionData1 -> routerFunctionData1.getPath().equals(routerOperation.getPath()) && this.isEqualArrays(routerFunctionData1.getConsumes(), routerOperation.getConsumes())).collect(Collectors.toList())).size() != 1) continue;
            this.fillRouterOperation((RouterFunctionData)routerFunctionDataList.get(0), routerOperation);
        }
    }

    private void calculateJsonView(io.swagger.v3.oas.annotations.Operation apiOperation, MethodAttributes methodAttributes, Method method) {
        JsonView jsonViewAnnotationForRequestBody;
        JsonView jsonViewAnnotation;
        if (apiOperation != null && apiOperation.ignoreJsonView()) {
            jsonViewAnnotation = null;
            jsonViewAnnotationForRequestBody = null;
        } else {
            jsonViewAnnotation = (JsonView)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, JsonView.class);
            jsonViewAnnotationForRequestBody = (JsonView)Arrays.stream(ReflectionUtils.getParameterAnnotations((Method)method)).filter(arr -> Arrays.stream(arr).anyMatch(annotation -> annotation.annotationType().equals(RequestBody.class) || annotation.annotationType().equals(org.springframework.web.bind.annotation.RequestBody.class))).flatMap(Arrays::stream).filter(annotation -> annotation.annotationType().equals(JsonView.class)).reduce((a, b) -> null).orElse((Annotation)jsonViewAnnotation);
        }
        methodAttributes.setJsonViewAnnotation(jsonViewAnnotation);
        methodAttributes.setJsonViewAnnotationForRequestBody(jsonViewAnnotationForRequestBody);
    }

    private boolean isEqualArrays(String[] array1, String[] array2) {
        Arrays.sort(array1);
        Arrays.sort(array2);
        return Arrays.equals(array1, array2);
    }

    private boolean isEqualMethods(RequestMethod[] requestMethods1, RequestMethod[] requestMethods2) {
        Arrays.sort(requestMethods1);
        Arrays.sort(requestMethods2);
        return Arrays.equals(requestMethods1, requestMethods2);
    }

    private void fillParametersList(Operation operation, Map<String, String> queryParams, MethodAttributes methodAttributes) {
        ArrayList<Parameter> parametersList = operation.getParameters();
        if (parametersList == null) {
            parametersList = new ArrayList<Parameter>();
        }
        Collection<Parameter> headersMap = AbstractRequestBuilder.getHeaders(methodAttributes, new LinkedHashMap<String, Parameter>());
        parametersList.addAll(headersMap);
        if (!CollectionUtils.isEmpty(queryParams)) {
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                Parameter parameter = new Parameter();
                parameter.setName(entry.getKey());
                parameter.setSchema((Schema)new StringSchema()._default(entry.getValue()));
                parameter.setRequired(Boolean.valueOf(true));
                parameter.setIn(ParameterIn.QUERY.toString());
                GenericParameterBuilder.mergeParameter(parametersList, parameter);
            }
            operation.setParameters(parametersList);
        }
    }

    private void fillRouterOperation(RouterFunctionData routerFunctionData, org.springdoc.core.models.RouterOperation routerOperation) {
        if (ArrayUtils.isEmpty((Object[])routerOperation.getConsumes())) {
            routerOperation.setConsumes(routerFunctionData.getConsumes());
        }
        if (ArrayUtils.isEmpty((Object[])routerOperation.getProduces())) {
            routerOperation.setProduces(routerFunctionData.getProduces());
        }
        if (ArrayUtils.isEmpty((Object[])routerOperation.getHeaders())) {
            routerOperation.setHeaders(routerFunctionData.getHeaders());
        }
        if (ArrayUtils.isEmpty((Object[])routerOperation.getMethods())) {
            routerOperation.setMethods(routerFunctionData.getMethods());
        }
        if (CollectionUtils.isEmpty(routerOperation.getQueryParams())) {
            routerOperation.setQueryParams(routerFunctionData.getQueryParams());
        }
    }

    private PathItem buildPathItem(RequestMethod requestMethod, Operation operation, String operationPath, Paths paths) {
        PathItem pathItemObject = paths.containsKey((Object)operationPath) ? (PathItem)paths.get((Object)operationPath) : new PathItem();
        switch (requestMethod) {
            case POST: {
                pathItemObject.post(operation);
                break;
            }
            case GET: {
                pathItemObject.get(operation);
                break;
            }
            case DELETE: {
                pathItemObject.delete(operation);
                break;
            }
            case PUT: {
                pathItemObject.put(operation);
                break;
            }
            case PATCH: {
                pathItemObject.patch(operation);
                break;
            }
            case TRACE: {
                pathItemObject.trace(operation);
                break;
            }
            case HEAD: {
                pathItemObject.head(operation);
                break;
            }
            case OPTIONS: {
                pathItemObject.options(operation);
                break;
            }
        }
        return pathItemObject;
    }

    private Operation getExistingOperation(Map<PathItem.HttpMethod, Operation> operationMap, RequestMethod requestMethod) {
        Operation existingOperation = null;
        if (!CollectionUtils.isEmpty(operationMap)) {
            switch (requestMethod) {
                case GET: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.GET);
                    break;
                }
                case POST: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.POST);
                    break;
                }
                case PUT: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.PUT);
                    break;
                }
                case DELETE: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.DELETE);
                    break;
                }
                case PATCH: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.PATCH);
                    break;
                }
                case HEAD: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.HEAD);
                    break;
                }
                case OPTIONS: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.OPTIONS);
                    break;
                }
            }
        }
        return existingOperation;
    }
}

