/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.GenericParameterBuilder;
import org.springdoc.core.MethodAttributes;
import org.springdoc.core.ParameterInfo;
import org.springdoc.core.RequestBodyInfo;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.RequestPart;

public class RequestBodyBuilder {
    private final GenericParameterBuilder parameterBuilder;

    public RequestBodyBuilder(GenericParameterBuilder parameterBuilder) {
        this.parameterBuilder = parameterBuilder;
    }

    public Optional<RequestBody> buildRequestBodyFromDoc(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody, String[] classConsumes, String[] methodConsumes, Components components, JsonView jsonViewAnnotation) {
        if (requestBody == null) {
            return Optional.empty();
        }
        RequestBody requestBodyObject = new RequestBody();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)requestBody.ref())) {
            requestBodyObject.set$ref(requestBody.ref());
            return Optional.of(requestBodyObject);
        }
        if (StringUtils.isNotBlank((CharSequence)requestBody.description())) {
            requestBodyObject.setDescription(requestBody.description());
            isEmpty = false;
        }
        if (requestBody.required()) {
            requestBodyObject.setRequired(Boolean.valueOf(requestBody.required()));
            isEmpty = false;
        }
        if (requestBody.extensions().length > 0) {
            Map extensions = AnnotationsUtils.getExtensions((Extension[])requestBody.extensions());
            extensions.forEach((arg_0, arg_1) -> ((RequestBody)requestBodyObject).addExtension(arg_0, arg_1));
            isEmpty = false;
        }
        if (requestBody.content().length > 0) {
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        AnnotationsUtils.getContent((io.swagger.v3.oas.annotations.media.Content[])requestBody.content(), (String[])(classConsumes == null ? new String[]{} : classConsumes), (String[])(methodConsumes == null ? new String[]{} : methodConsumes), null, (Components)components, (JsonView)jsonViewAnnotation).ifPresent(arg_0 -> ((RequestBody)requestBodyObject).setContent(arg_0));
        return Optional.of(requestBodyObject);
    }

    public void calculateRequestBodyInfo(Components components, MethodAttributes methodAttributes, ParameterInfo parameterInfo, RequestBodyInfo requestBodyInfo) {
        RequestBody requestBody = requestBodyInfo.getRequestBody();
        MethodParameter methodParameter = parameterInfo.getMethodParameter();
        if (requestBody == null) {
            io.swagger.v3.oas.annotations.parameters.RequestBody requestBodyDoc = (io.swagger.v3.oas.annotations.parameters.RequestBody)methodParameter.getParameterAnnotation(io.swagger.v3.oas.annotations.parameters.RequestBody.class);
            requestBody = this.buildRequestBodyFromDoc(requestBodyDoc, methodAttributes.getClassConsumes(), methodAttributes.getMethodConsumes(), components, null).orElse(null);
        }
        RequestPart requestPart = (RequestPart)methodParameter.getParameterAnnotation(RequestPart.class);
        String paramName = null;
        if (requestPart != null) {
            paramName = (String)StringUtils.defaultIfEmpty((CharSequence)requestPart.value(), (CharSequence)requestPart.name());
        }
        paramName = (String)StringUtils.defaultIfEmpty(paramName, (CharSequence)parameterInfo.getpName());
        parameterInfo.setpName(paramName);
        requestBody = this.buildRequestBody(requestBody, components, methodAttributes, parameterInfo, requestBodyInfo);
        requestBodyInfo.setRequestBody(requestBody);
    }

    private RequestBody buildRequestBody(RequestBody requestBody, Components components, MethodAttributes methodAttributes, ParameterInfo parameterInfo, RequestBodyInfo requestBodyInfo) {
        Schema schema;
        if (requestBody == null) {
            requestBody = new RequestBody();
        }
        if (parameterInfo.getParameterModel() != null) {
            Parameter parameter = parameterInfo.getParameterModel();
            if (StringUtils.isNotBlank((CharSequence)parameter.getDescription())) {
                requestBody.setDescription(parameter.getDescription());
            }
            requestBody.setRequired(parameter.getRequired());
        }
        if (requestBody.getContent() == null) {
            schema = this.parameterBuilder.calculateSchema(components, parameterInfo, requestBodyInfo, methodAttributes.getJsonViewAnnotationForRequestBody());
            this.buildContent(requestBody, methodAttributes, schema);
        } else if (requestBodyInfo.getRequestBody() != null) {
            schema = this.parameterBuilder.calculateSchema(components, parameterInfo, requestBodyInfo, methodAttributes.getJsonViewAnnotationForRequestBody());
            this.mergeContent(requestBody, methodAttributes, schema);
        }
        return requestBody;
    }

    private void mergeContent(RequestBody requestBody, MethodAttributes methodAttributes, Schema<?> schema) {
        Content content = requestBody.getContent();
        this.buildContent(requestBody, methodAttributes, schema, content);
    }

    private void buildContent(RequestBody requestBody, MethodAttributes methodAttributes, Schema<?> schema) {
        Content content = new Content();
        this.buildContent(requestBody, methodAttributes, schema, content);
    }

    private void buildContent(RequestBody requestBody, MethodAttributes methodAttributes, Schema<?> schema, Content content) {
        for (String value : methodAttributes.getMethodConsumes()) {
            MediaType mediaTypeObject = new MediaType();
            mediaTypeObject.setSchema(schema);
            if (content.get((Object)value) != null) {
                mediaTypeObject.setExample(((MediaType)content.get((Object)value)).getExample());
                mediaTypeObject.setExamples(((MediaType)content.get((Object)value)).getExamples());
                mediaTypeObject.setEncoding(((MediaType)content.get((Object)value)).getEncoding());
            }
            content.addMediaType(value, mediaTypeObject);
        }
        requestBody.setContent(content);
    }
}

