/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AdditionalModelsConverter
implements ModelConverter {
    private static final Map<Class, Class> modelToClassMap = new HashMap<Class, Class>();
    private static final Map<Class, Schema> modelToSchemaMap = new HashMap<Class, Schema>();

    public Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        JavaType javaType = Json.mapper().constructType(type.getType());
        if (javaType != null) {
            Class cls = javaType.getRawClass();
            if (modelToSchemaMap.containsKey(cls)) {
                return modelToSchemaMap.get(cls);
            }
            if (modelToClassMap.containsKey(cls)) {
                type = new AnnotatedType((Type)modelToClassMap.get(cls));
            }
        }
        if (chain.hasNext()) {
            return chain.next().resolve(type, context, chain);
        }
        return null;
    }

    public static void replaceWithClass(Class source, Class target) {
        modelToClassMap.put(source, target);
    }

    public static void replaceWithSchema(Class source, Schema target) {
        modelToSchemaMap.put(source, target);
    }
}

