/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.springdoc.core.converters.ConverterUtils;

public class ResponseSupportConverter
implements ModelConverter {
    public Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        Class cls;
        JavaType javaType = Json.mapper().constructType(type.getType());
        if (javaType != null && ConverterUtils.isResponseTypeWrapper(cls = javaType.getRawClass())) {
            JavaType innerType = javaType.getBindings().getBoundType(0);
            if (innerType == null) {
                return new StringSchema();
            }
            if (innerType.getBindings() != null && ConverterUtils.isResponseTypeWrapper(innerType.getRawClass())) {
                type = new AnnotatedType((Type)innerType).jsonViewAnnotation(type.getJsonViewAnnotation()).resolveAsRef(true);
                return this.resolve(type, context, chain);
            }
            type = new AnnotatedType((Type)innerType).jsonViewAnnotation(type.getJsonViewAnnotation()).resolveAsRef(true);
        }
        if (chain.hasNext()) {
            return chain.next().resolve(type, context, chain);
        }
        return null;
    }
}

