/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.OpenAPIBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
@ConfigurationProperties(prefix="springdoc.swagger-ui")
@ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={OpenAPIBuilder.class})
public class SwaggerUiConfigProperties {
    public static final String CONFIG_URL_PROPERTY = "configUrl";
    private static List<SwaggerUrl> swaggerUrls = new ArrayList<SwaggerUrl>();
    private String path = "/swagger-ui.html";
    private String layout;
    private String configUrl;
    private String validatorUrl;
    private String filter;
    private String operationsSorter;
    private String tagsSorter;
    private Boolean deepLinking;
    private Boolean displayOperationId;
    private Integer defaultModelsExpandDepth;
    private Integer defaultModelExpandDepth;
    private String defaultModelRendering;
    private Boolean displayRequestDuration;
    private String docExpansion;
    private Integer maxDisplayedTags;
    private Boolean showExtensions;
    private Boolean showCommonExtensions;
    private List<String> supportedSubmitMethods;
    private String oauth2RedirectUrl = "/swagger-ui/oauth2-redirect.html";
    private String url;

    public static void addGroup(String group) {
        SwaggerUrl swaggerUrl = new SwaggerUrl(group);
        swaggerUrls.add(swaggerUrl);
    }

    public static void addGroup(String group, String url) {
        SwaggerUrl swaggerUrl = new SwaggerUrl(group, url);
        swaggerUrls.add(swaggerUrl);
    }

    public static List<SwaggerUrl> getSwaggerUrls() {
        return swaggerUrls;
    }

    public static void setSwaggerUrls(List<SwaggerUrl> swaggerUrls) {
        SwaggerUiConfigProperties.swaggerUrls = swaggerUrls;
    }

    public static void addUrl(String url) {
        swaggerUrls.forEach(elt -> {
            if (StringUtils.isEmpty((CharSequence)((SwaggerUrl)elt).url)) {
                elt.setUrl(url + "/" + elt.getName());
            }
        });
    }

    public Map<String, Object> getConfigParameters() {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        this.put("layout", this.layout, params);
        this.put(CONFIG_URL_PROPERTY, this.configUrl, params);
        this.put("validatorUrl", this.validatorUrl, params);
        this.put("filter", this.filter, params);
        this.put("deepLinking", this.deepLinking, params);
        this.put("displayOperationId", this.displayOperationId, params);
        this.put("defaultModelsExpandDepth", this.defaultModelsExpandDepth, params);
        this.put("defaultModelExpandDepth", this.defaultModelExpandDepth, params);
        this.put("defaultModelRendering", this.defaultModelRendering, params);
        this.put("displayRequestDuration", this.displayRequestDuration, params);
        this.put("docExpansion", this.docExpansion, params);
        this.put("maxDisplayedTags", this.maxDisplayedTags, params);
        this.put("showExtensions", this.showExtensions, params);
        this.put("showCommonExtensions", this.showCommonExtensions, params);
        this.put("operationsSorter", this.operationsSorter, params);
        this.put("tagsSorter", this.tagsSorter, params);
        if (!CollectionUtils.isEmpty(this.supportedSubmitMethods)) {
            this.put("supportedSubmitMethods", this.supportedSubmitMethods.toString(), params);
        }
        this.put("oauth2RedirectUrl", this.oauth2RedirectUrl, params);
        this.put("url", this.url, params);
        this.put("urls", swaggerUrls, params);
        return params;
    }

    protected void put(String urls, List<SwaggerUrl> swaggerUrls, Map<String, Object> params) {
        if (!CollectionUtils.isEmpty(swaggerUrls = swaggerUrls.stream().filter(elt -> StringUtils.isNotEmpty((CharSequence)elt.getUrl())).collect(Collectors.toList()))) {
            params.put(urls, swaggerUrls);
        }
    }

    protected void put(String name, Integer value, Map<String, Object> params) {
        if (value != null) {
            params.put(name, value.toString());
        }
    }

    protected void put(String name, Boolean value, Map<String, Object> params) {
        if (value != null) {
            params.put(name, value.toString());
        }
    }

    protected void put(String name, String value, Map<String, Object> params) {
        if (!StringUtils.isEmpty((CharSequence)value)) {
            params.put(name, value);
        }
    }

    public String getValidatorUrl() {
        return this.validatorUrl;
    }

    public void setValidatorUrl(String validatorUrl) {
        this.validatorUrl = validatorUrl;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getConfigUrl() {
        return this.configUrl;
    }

    public void setConfigUrl(String configUrl) {
        this.configUrl = configUrl;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getOperationsSorter() {
        return this.operationsSorter;
    }

    public void setOperationsSorter(String operationsSorter) {
        this.operationsSorter = operationsSorter;
    }

    public String getTagsSorter() {
        return this.tagsSorter;
    }

    public void setTagsSorter(String tagsSorter) {
        this.tagsSorter = tagsSorter;
    }

    public Boolean getDeepLinking() {
        return this.deepLinking;
    }

    public void setDeepLinking(Boolean deepLinking) {
        this.deepLinking = deepLinking;
    }

    public Boolean getDisplayOperationId() {
        return this.displayOperationId;
    }

    public void setDisplayOperationId(Boolean displayOperationId) {
        this.displayOperationId = displayOperationId;
    }

    public Integer getDefaultModelsExpandDepth() {
        return this.defaultModelsExpandDepth;
    }

    public void setDefaultModelsExpandDepth(Integer defaultModelsExpandDepth) {
        this.defaultModelsExpandDepth = defaultModelsExpandDepth;
    }

    public Integer getDefaultModelExpandDepth() {
        return this.defaultModelExpandDepth;
    }

    public void setDefaultModelExpandDepth(Integer defaultModelExpandDepth) {
        this.defaultModelExpandDepth = defaultModelExpandDepth;
    }

    public String getDefaultModelRendering() {
        return this.defaultModelRendering;
    }

    public void setDefaultModelRendering(String defaultModelRendering) {
        this.defaultModelRendering = defaultModelRendering;
    }

    public Boolean getDisplayRequestDuration() {
        return this.displayRequestDuration;
    }

    public void setDisplayRequestDuration(Boolean displayRequestDuration) {
        this.displayRequestDuration = displayRequestDuration;
    }

    public String getDocExpansion() {
        return this.docExpansion;
    }

    public void setDocExpansion(String docExpansion) {
        this.docExpansion = docExpansion;
    }

    public Integer getMaxDisplayedTags() {
        return this.maxDisplayedTags;
    }

    public void setMaxDisplayedTags(Integer maxDisplayedTags) {
        this.maxDisplayedTags = maxDisplayedTags;
    }

    public Boolean getShowExtensions() {
        return this.showExtensions;
    }

    public void setShowExtensions(Boolean showExtensions) {
        this.showExtensions = showExtensions;
    }

    public Boolean getShowCommonExtensions() {
        return this.showCommonExtensions;
    }

    public void setShowCommonExtensions(Boolean showCommonExtensions) {
        this.showCommonExtensions = showCommonExtensions;
    }

    public List<String> getSupportedSubmitMethods() {
        return this.supportedSubmitMethods;
    }

    public void setSupportedSubmitMethods(List<String> supportedSubmitMethods) {
        this.supportedSubmitMethods = supportedSubmitMethods;
    }

    public String getOauth2RedirectUrl() {
        return this.oauth2RedirectUrl;
    }

    public void setOauth2RedirectUrl(String oauth2RedirectUrl) {
        this.oauth2RedirectUrl = oauth2RedirectUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isValidUrl(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static class SwaggerUrl {
        private String url;
        private String name;

        public SwaggerUrl(String group, String url) {
            this.url = url;
            this.name = group;
        }

        public SwaggerUrl(String group) {
            this.name = group;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

