/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
@ConfigurationProperties(prefix="springdoc.swagger-ui")
public class SwaggerUiConfigProperties {
    private String path = "/swagger-ui.html";
    private String layout;
    private String configUrl;
    private String filter;
    private String operationsSorter;
    private String tagsSorter;
    private Boolean deepLinking;
    private Boolean displayOperationId;
    private Integer defaultModelsExpandDepth;
    private Integer defaultModelExpandDepth;
    private String defaultModelRendering;
    private Boolean displayRequestDuration;
    private String docExpansion;
    private Integer maxDisplayedTags;
    private Boolean showExtensions;
    private Boolean showCommonExtensions;
    private List<String> supportedSubmitMethods;
    private String oauth2RedirectUrl;

    public Map<String, String> getConfigParameters() {
        TreeMap<String, String> params = new TreeMap<String, String>();
        this.put("layout", this.layout, params);
        this.put("configUrl", this.configUrl, params);
        this.put("filter", this.filter, params);
        this.put("deepLinking", this.deepLinking, params);
        this.put("displayOperationId", this.displayOperationId, params);
        this.put("defaultModelsExpandDepth", this.defaultModelsExpandDepth, params);
        this.put("defaultModelExpandDepth", this.defaultModelExpandDepth, params);
        this.put("defaultModelRendering", this.defaultModelRendering, params);
        this.put("displayRequestDuration", this.displayRequestDuration, params);
        this.put("docExpansion", this.docExpansion, params);
        this.put("maxDisplayedTags", this.maxDisplayedTags, params);
        this.put("showExtensions", this.showExtensions, params);
        this.put("showCommonExtensions", this.showCommonExtensions, params);
        this.put("operationsSorter", this.operationsSorter, params);
        this.put("tagsSorter", this.tagsSorter, params);
        if (!CollectionUtils.isEmpty(this.supportedSubmitMethods)) {
            this.put("supportedSubmitMethods", this.supportedSubmitMethods.toString(), params);
        }
        this.put("oauth2RedirectUrl", this.oauth2RedirectUrl, params);
        return params;
    }

    protected void put(String name, Integer value, Map<String, String> params) {
        if (value != null) {
            params.put(name, value.toString());
        }
    }

    protected void put(String name, Boolean value, Map<String, String> params) {
        if (value != null) {
            params.put(name, value.toString());
        }
    }

    protected void put(String name, String value, Map<String, String> params) {
        if (!StringUtils.isEmpty((CharSequence)value)) {
            params.put(name, value);
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getConfigUrl() {
        return this.configUrl;
    }

    public void setConfigUrl(String configUrl) {
        this.configUrl = configUrl;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getOperationsSorter() {
        return this.operationsSorter;
    }

    public void setOperationsSorter(String operationsSorter) {
        this.operationsSorter = operationsSorter;
    }

    public String getTagsSorter() {
        return this.tagsSorter;
    }

    public void setTagsSorter(String tagsSorter) {
        this.tagsSorter = tagsSorter;
    }

    public Boolean getDeepLinking() {
        return this.deepLinking;
    }

    public void setDeepLinking(Boolean deepLinking) {
        this.deepLinking = deepLinking;
    }

    public Boolean getDisplayOperationId() {
        return this.displayOperationId;
    }

    public void setDisplayOperationId(Boolean displayOperationId) {
        this.displayOperationId = displayOperationId;
    }

    public Integer getDefaultModelsExpandDepth() {
        return this.defaultModelsExpandDepth;
    }

    public void setDefaultModelsExpandDepth(Integer defaultModelsExpandDepth) {
        this.defaultModelsExpandDepth = defaultModelsExpandDepth;
    }

    public Integer getDefaultModelExpandDepth() {
        return this.defaultModelExpandDepth;
    }

    public void setDefaultModelExpandDepth(Integer defaultModelExpandDepth) {
        this.defaultModelExpandDepth = defaultModelExpandDepth;
    }

    public String getDefaultModelRendering() {
        return this.defaultModelRendering;
    }

    public void setDefaultModelRendering(String defaultModelRendering) {
        this.defaultModelRendering = defaultModelRendering;
    }

    public Boolean getDisplayRequestDuration() {
        return this.displayRequestDuration;
    }

    public void setDisplayRequestDuration(Boolean displayRequestDuration) {
        this.displayRequestDuration = displayRequestDuration;
    }

    public String getDocExpansion() {
        return this.docExpansion;
    }

    public void setDocExpansion(String docExpansion) {
        this.docExpansion = docExpansion;
    }

    public Integer getMaxDisplayedTags() {
        return this.maxDisplayedTags;
    }

    public void setMaxDisplayedTags(Integer maxDisplayedTags) {
        this.maxDisplayedTags = maxDisplayedTags;
    }

    public Boolean getShowExtensions() {
        return this.showExtensions;
    }

    public void setShowExtensions(Boolean showExtensions) {
        this.showExtensions = showExtensions;
    }

    public Boolean getShowCommonExtensions() {
        return this.showCommonExtensions;
    }

    public void setShowCommonExtensions(Boolean showCommonExtensions) {
        this.showCommonExtensions = showCommonExtensions;
    }

    public List<String> getSupportedSubmitMethods() {
        return this.supportedSubmitMethods;
    }

    public void setSupportedSubmitMethods(List<String> supportedSubmitMethods) {
        this.supportedSubmitMethods = supportedSubmitMethods;
    }

    public String getOauth2RedirectUrl() {
        return this.oauth2RedirectUrl;
    }

    public void setOauth2RedirectUrl(String oauth2RedirectUrl) {
        this.oauth2RedirectUrl = oauth2RedirectUrl;
    }
}

