/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.springdoc.core.ParameterBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;

public abstract class AbstractRequestBuilder {
    @Autowired
    protected ParameterBuilder parameterBuilder;

    public abstract Operation build(Components var1, HandlerMethod var2, RequestMethod var3, Operation var4, String[] var5);

    protected <A extends Annotation> A getParameterAnnotation(HandlerMethod handlerMethod, Parameter parameter, int i, Class<A> annotationType) {
        Annotation parameterDoc;
        block1: {
            Method methodOverriden;
            parameterDoc = AnnotationUtils.getAnnotation((AnnotatedElement)parameter, annotationType);
            if (parameterDoc != null) break block1;
            Set methods = MethodUtils.getOverrideHierarchy((Method)handlerMethod.getMethod(), (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE);
            Iterator iterator = methods.iterator();
            while (iterator.hasNext() && (parameterDoc = AnnotationUtils.getAnnotation((AnnotatedElement)(methodOverriden = (Method)iterator.next()).getParameters()[i], annotationType)) == null) {
            }
        }
        return (A)parameterDoc;
    }

    protected io.swagger.v3.oas.models.parameters.Parameter buildParamDefault(RequestMethod requestMethod, String pNames, Parameter parameters, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        if (RequestMethod.GET.equals((Object)requestMethod) && parameter == null) {
            parameter = this.buildParam("query", null, parameters, Boolean.TRUE, pNames, null);
        }
        return parameter;
    }

    protected io.swagger.v3.oas.models.parameters.Parameter buildParams(String pName, Components components, Parameter parameters, int index, io.swagger.v3.oas.models.parameters.Parameter parameter, HandlerMethod handlerMethod) {
        RequestHeader requestHeader = this.getParameterAnnotation(handlerMethod, parameters, index, RequestHeader.class);
        RequestParam requestParam = this.getParameterAnnotation(handlerMethod, parameters, index, RequestParam.class);
        PathVariable pathVar = this.getParameterAnnotation(handlerMethod, parameters, index, PathVariable.class);
        if (requestHeader != null) {
            String name = StringUtils.isBlank((CharSequence)requestHeader.value()) ? pName : requestHeader.value();
            parameter = this.buildParam("header", components, parameters, requestHeader.required(), name, parameter);
        } else if (requestParam != null) {
            String name = StringUtils.isBlank((CharSequence)requestParam.value()) ? pName : requestParam.value();
            parameter = this.buildParam("query", components, parameters, requestParam.required(), name, parameter);
        } else if (pathVar != null) {
            String name = StringUtils.isBlank((CharSequence)pathVar.value()) ? pName : pathVar.value();
            parameter = this.buildParam("path", components, parameters, Boolean.TRUE, name, parameter);
        }
        return parameter;
    }

    private io.swagger.v3.oas.models.parameters.Parameter buildParam(String in, Components components, Parameter parameters, Boolean required, String name, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        if (parameter == null) {
            parameter = new io.swagger.v3.oas.models.parameters.Parameter();
        }
        parameter.setIn(in);
        parameter.setRequired(required);
        parameter.setName(name);
        Schema<?> schema = this.parameterBuilder.calculateSchema(components, parameters, name);
        parameter.setSchema(schema);
        return parameter;
    }

    protected RequestBody buildRequestBody(Components components, String[] allConsumes, Parameter parameter, io.swagger.v3.oas.annotations.Parameter parameterDoc, String paramName) {
        RequestBody requestBody = new RequestBody();
        Schema<?> schema = this.parameterBuilder.calculateSchema(components, parameter, paramName);
        MediaType mediaType = null;
        if (schema != null && schema.getType() != null) {
            mediaType = new MediaType();
            mediaType.setSchema(schema);
        } else {
            Class<?> returnType = parameter.getType();
            mediaType = this.calculateSchema(components, returnType);
        }
        Content content1 = new Content();
        if (ArrayUtils.isNotEmpty((Object[])allConsumes)) {
            for (String value : allConsumes) {
                this.setMediaTypeToContent(schema, content1, value);
            }
        } else {
            content1.addMediaType("*/*", mediaType);
        }
        requestBody.setContent(content1);
        if (parameterDoc != null) {
            if (StringUtils.isNotBlank((CharSequence)parameterDoc.description())) {
                requestBody.setDescription(parameterDoc.description());
            }
            requestBody.setRequired(Boolean.valueOf(parameterDoc.required()));
        }
        return requestBody;
    }

    private MediaType calculateSchema(Components components, Type returnType) {
        ResolvedSchema resolvedSchema = ModelConverters.getInstance().resolveAsResolvedSchema(new AnnotatedType(returnType).resolveAsRef(true));
        MediaType mediaType = new MediaType();
        if (resolvedSchema.schema != null) {
            Map schemaMap;
            Schema returnTypeSchema = resolvedSchema.schema;
            if (returnTypeSchema != null) {
                mediaType.setSchema(returnTypeSchema);
            }
            if ((schemaMap = resolvedSchema.referencedSchemas) != null) {
                schemaMap.forEach((arg_0, arg_1) -> ((Components)components).addSchemas(arg_0, arg_1));
            }
        }
        return mediaType;
    }

    protected void applyBeanValidatorAnnotations(io.swagger.v3.oas.models.parameters.Parameter parameter, List<Annotation> annotations) {
        Max max;
        Min min;
        HashMap annos = new HashMap();
        if (annotations != null) {
            annotations.forEach(annotation -> annos.put(annotation.annotationType().getName(), annotation));
        }
        if (annos.containsKey(NotNull.class.getName())) {
            parameter.setRequired(Boolean.valueOf(true));
        }
        Schema schema = parameter.getSchema();
        if (annos.containsKey(Min.class.getName())) {
            min = (Min)annos.get(Min.class.getName());
            schema.setMinimum(BigDecimal.valueOf(min.value()));
        }
        if (annos.containsKey(Max.class.getName())) {
            max = (Max)annos.get(Max.class.getName());
            schema.setMaximum(BigDecimal.valueOf(max.value()));
        }
        if (annos.containsKey(Size.class.getName())) {
            Size size = (Size)annos.get(Size.class.getName());
            if ("array".equals(schema.getType())) {
                schema.setMinItems(Integer.valueOf(size.min()));
                schema.setMaxItems(Integer.valueOf(size.max()));
            } else if ("string".equals(schema.getType())) {
                schema.setMinLength(Integer.valueOf(size.min()));
                schema.setMaxLength(Integer.valueOf(size.max()));
            }
        }
        if (annos.containsKey(DecimalMin.class.getName())) {
            min = (DecimalMin)annos.get(DecimalMin.class.getName());
            if (min.inclusive()) {
                schema.setMinimum(BigDecimal.valueOf(Double.valueOf(min.value())));
            } else {
                schema.setExclusiveMinimum(Boolean.valueOf(!min.inclusive()));
            }
        }
        if (annos.containsKey(DecimalMax.class.getName())) {
            max = (DecimalMax)annos.get(DecimalMax.class.getName());
            if (max.inclusive()) {
                schema.setMaximum(BigDecimal.valueOf(Double.valueOf(max.value())));
            } else {
                schema.setExclusiveMaximum(Boolean.valueOf(!max.inclusive()));
            }
        }
        if (annos.containsKey(Pattern.class.getName())) {
            Pattern pattern = (Pattern)annos.get(Pattern.class.getName());
            schema.setPattern(pattern.regexp());
        }
    }

    private void setMediaTypeToContent(Schema schema, Content content, String value) {
        MediaType mediaTypeObject = new MediaType();
        mediaTypeObject.setSchema(schema);
        content.addMediaType(value, mediaTypeObject);
    }
}

