/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.method.HandlerMethod;

@Component
public class TagsBuilder {
    public Operation build(HandlerMethod handlerMethod, Operation operation, OpenAPI openAPI) {
        Optional tags;
        List classTags = ReflectionUtils.getRepeatableAnnotations((Class)handlerMethod.getBeanType(), Tag.class);
        List methodTags = ReflectionUtils.getRepeatableAnnotations((Method)handlerMethod.getMethod(), Tag.class);
        ArrayList allTags = new ArrayList();
        HashSet tagsStr = new HashSet();
        if (!CollectionUtils.isEmpty((Collection)methodTags)) {
            tagsStr.addAll(methodTags.stream().map(Tag::name).collect(Collectors.toSet()));
            allTags.addAll(methodTags);
        }
        if (!CollectionUtils.isEmpty((Collection)classTags)) {
            tagsStr.addAll(classTags.stream().map(Tag::name).collect(Collectors.toSet()));
            allTags.addAll(classTags);
        }
        if ((tags = AnnotationsUtils.getTags((Tag[])allTags.toArray(new Tag[allTags.size()]), (boolean)true)).isPresent()) {
            Set tagsSet = (Set)tags.get();
            List openApiTags = openAPI.getTags();
            if (!CollectionUtils.isEmpty((Collection)openApiTags)) {
                tagsSet.addAll(openApiTags);
            }
            openAPI.setTags(new ArrayList(tagsSet));
        }
        if (!CollectionUtils.isEmpty(tagsStr)) {
            operation.setTags(new ArrayList(tagsStr));
        }
        return operation;
    }
}

