/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.ParameterProcessor;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.RequestBodyInfo;
import org.springdoc.core.SpringDocAnnotationsUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.multipart.MultipartFile;

@Component
public class ParameterBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterBuilder.class);

    public io.swagger.v3.oas.models.parameters.Parameter buildParameterFromDoc(Parameter parameterDoc, Components components) {
        io.swagger.v3.oas.models.parameters.Parameter parameter = new io.swagger.v3.oas.models.parameters.Parameter();
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.description())) {
            parameter.setDescription(parameterDoc.description());
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.name())) {
            parameter.setName(parameterDoc.name());
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.in().toString())) {
            parameter.setIn(parameterDoc.in().toString());
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.example())) {
            try {
                parameter.setExample((Object)Json.mapper().readTree(parameterDoc.example()));
            }
            catch (IOException e) {
                parameter.setExample((Object)parameterDoc.example());
            }
        }
        if (parameterDoc.deprecated()) {
            parameter.setDeprecated(Boolean.valueOf(parameterDoc.deprecated()));
        }
        if (parameterDoc.required()) {
            parameter.setRequired(Boolean.valueOf(parameterDoc.required()));
        }
        if (parameterDoc.allowEmptyValue()) {
            parameter.setAllowEmptyValue(Boolean.valueOf(parameterDoc.allowEmptyValue()));
        }
        if (parameterDoc.allowReserved()) {
            parameter.setAllowReserved(Boolean.valueOf(parameterDoc.allowReserved()));
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.ref())) {
            parameter.$ref(parameterDoc.ref());
        } else {
            Type type = ParameterProcessor.getParameterType((Parameter)parameterDoc);
            io.swagger.v3.oas.models.media.Schema schema = null;
            schema = parameterDoc.schema() != null ? (io.swagger.v3.oas.models.media.Schema)AnnotationsUtils.getSchemaFromAnnotation((Schema)parameterDoc.schema(), (Components)components, null).orElse(null) : this.calculateSchema(components, null, parameter.getName(), type, null);
            parameter.setSchema(schema);
        }
        this.setExamples(parameterDoc, parameter);
        this.setExtensions(parameterDoc, parameter);
        this.setParameterStyle(parameter, parameterDoc);
        this.setParameterExplode(parameter, parameterDoc);
        return parameter;
    }

    public io.swagger.v3.oas.models.media.Schema calculateSchema(Components components, java.lang.reflect.Parameter parameter, String paramName, Type type, RequestBodyInfo requestBodyInfo) {
        JavaType ct;
        Type returnType;
        io.swagger.v3.oas.models.media.Schema schemaN = null;
        Class<?> schemaImplementation = null;
        if (parameter != null) {
            returnType = parameter.getParameterizedType();
            ct = this.constructType(parameter.getType());
            schemaImplementation = parameter.getType();
        } else {
            returnType = type;
            ct = this.constructType(type);
            try {
                schemaImplementation = Class.forName(returnType.getTypeName());
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Class Not Found in classpath : {}", (Object)e.getMessage());
            }
        }
        if (MultipartFile.class.isAssignableFrom(ct.getRawClass())) {
            schemaN = requestBodyInfo.initMergedSchema();
            schemaN.addProperties(paramName, (io.swagger.v3.oas.models.media.Schema)new FileSchema());
            return schemaN;
        }
        if (returnType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)returnType;
            if (parameterizedType.getActualTypeArguments()[0].getTypeName().equals(MultipartFile.class.getName())) {
                schemaN = requestBodyInfo.initMergedSchema();
                ArraySchema schemafile = new ArraySchema();
                schemafile.items((io.swagger.v3.oas.models.media.Schema)new FileSchema());
                schemaN.addProperties(paramName, (io.swagger.v3.oas.models.media.Schema)new ArraySchema().items((io.swagger.v3.oas.models.media.Schema)new FileSchema()));
                return schemaN;
            }
            schemaN = SpringDocAnnotationsUtils.extractSchema(components, returnType);
        } else {
            schemaN = SpringDocAnnotationsUtils.resolveSchemaFromType(schemaImplementation, components, null);
        }
        if (requestBodyInfo != null && requestBodyInfo.getMergedSchema() != null) {
            requestBodyInfo.getMergedSchema().addProperties(paramName, schemaN);
            schemaN = requestBodyInfo.getMergedSchema();
        }
        return schemaN;
    }

    public <A extends Annotation> A getParameterAnnotation(HandlerMethod handlerMethod, java.lang.reflect.Parameter parameter, int i, Class<A> annotationType) {
        Annotation parameterDoc;
        block1: {
            Method methodOverriden;
            parameterDoc = AnnotationUtils.getAnnotation((AnnotatedElement)parameter, annotationType);
            if (parameterDoc != null) break block1;
            Set methods = MethodUtils.getOverrideHierarchy((Method)handlerMethod.getMethod(), (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE);
            Iterator iterator = methods.iterator();
            while (iterator.hasNext() && (parameterDoc = AnnotationUtils.getAnnotation((AnnotatedElement)(methodOverriden = (Method)iterator.next()).getParameters()[i], annotationType)) == null) {
            }
        }
        return (A)parameterDoc;
    }

    private void setExamples(Parameter parameterDoc, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        HashMap exampleMap = new HashMap();
        if (parameterDoc.examples().length == 1 && StringUtils.isBlank((CharSequence)parameterDoc.examples()[0].name())) {
            Optional exampleOptional = AnnotationsUtils.getExample((ExampleObject)parameterDoc.examples()[0]);
            if (exampleOptional.isPresent()) {
                parameter.setExample(exampleOptional.get());
            }
        } else {
            for (ExampleObject exampleObject : parameterDoc.examples()) {
                AnnotationsUtils.getExample((ExampleObject)exampleObject).ifPresent(example -> exampleMap.put(exampleObject.name(), example));
            }
        }
        if (exampleMap.size() > 0) {
            parameter.setExamples(exampleMap);
        }
    }

    private void setExtensions(Parameter parameterDoc, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        if (parameterDoc.extensions().length > 0) {
            Map extensionMap = AnnotationsUtils.getExtensions((Extension[])parameterDoc.extensions());
            for (Map.Entry entry : extensionMap.entrySet()) {
                parameter.addExtension((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private void setParameterExplode(io.swagger.v3.oas.models.parameters.Parameter parameter, Parameter p) {
        if (this.isExplodable(p)) {
            if (Explode.TRUE.equals((Object)p.explode())) {
                parameter.setExplode(Boolean.TRUE);
            } else if (Explode.FALSE.equals((Object)p.explode())) {
                parameter.setExplode(Boolean.FALSE);
            }
        }
    }

    private void setParameterStyle(io.swagger.v3.oas.models.parameters.Parameter parameter, Parameter p) {
        if (StringUtils.isNotBlank((CharSequence)p.style().toString())) {
            parameter.setStyle(Parameter.StyleEnum.valueOf((String)p.style().toString().toUpperCase()));
        }
    }

    private boolean isExplodable(Parameter p) {
        Class implementation;
        Schema schema = p.schema();
        boolean explode = true;
        if (schema != null && (implementation = schema.implementation()) == Void.class && !schema.type().equals("object") && !schema.type().equals("array")) {
            explode = false;
        }
        return explode;
    }

    private JavaType constructType(Type type) {
        return TypeFactory.defaultInstance().constructType(type);
    }
}

