/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.prompt;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.springaicommunity.mcp.annotation.McpPrompt;
import org.springaicommunity.mcp.annotation.PromptAdaptor;
import org.springaicommunity.mcp.method.prompt.SyncMcpPromptMethodCallback;
import reactor.core.publisher.Mono;

public class SyncMcpPromptProvider {
    private final List<Object> promptObjects;

    public SyncMcpPromptProvider(List<Object> promptObjects) {
        Assert.notNull(promptObjects, (String)"promptObjects cannot be null");
        this.promptObjects = promptObjects;
    }

    public List<McpServerFeatures.SyncPromptSpecification> getPromptSpecifications() {
        List<McpServerFeatures.SyncPromptSpecification> syncPromptSpecification = this.promptObjects.stream().map(resourceObject -> Stream.of(this.doGetClassMethods(resourceObject)).filter(method -> method.isAnnotationPresent(McpPrompt.class)).filter(method -> !Mono.class.isAssignableFrom(method.getReturnType())).map(mcpPromptMethod -> {
            McpPrompt promptAnnotation = mcpPromptMethod.getAnnotation(McpPrompt.class);
            McpSchema.Prompt mcpPrompt = PromptAdaptor.asPrompt(promptAnnotation, mcpPromptMethod);
            SyncMcpPromptMethodCallback methodCallback = ((SyncMcpPromptMethodCallback.Builder)((SyncMcpPromptMethodCallback.Builder)((SyncMcpPromptMethodCallback.Builder)SyncMcpPromptMethodCallback.builder().method((Method)mcpPromptMethod)).bean(resourceObject)).prompt(mcpPrompt)).build();
            return new McpServerFeatures.SyncPromptSpecification(mcpPrompt, (BiFunction)methodCallback);
        }).toList()).flatMap(Collection::stream).toList();
        return syncPromptSpecification;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }
}

