/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.progress;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.springaicommunity.mcp.annotation.McpProgress;
import org.springaicommunity.mcp.method.progress.AsyncMcpProgressMethodCallback;
import org.springaicommunity.mcp.method.progress.AsyncProgressSpecification;
import reactor.core.publisher.Mono;

public class AsyncMcpProgressProvider {
    private final List<Object> progressObjects;

    public AsyncMcpProgressProvider(List<Object> progressObjects) {
        this.progressObjects = progressObjects != null ? progressObjects : List.of();
    }

    public List<AsyncProgressSpecification> getProgressSpecifications() {
        List<AsyncProgressSpecification> progressHandlers = this.progressObjects.stream().map(progressObject -> Stream.of(this.doGetClassMethods(progressObject)).filter(method -> method.isAnnotationPresent(McpProgress.class)).filter(method -> {
            ParameterizedType paramType;
            Type[] typeArguments;
            Class<?> returnType = method.getReturnType();
            if (!Mono.class.isAssignableFrom(returnType)) {
                return false;
            }
            Type genericReturnType = method.getGenericReturnType();
            if (genericReturnType instanceof ParameterizedType && (typeArguments = (paramType = (ParameterizedType)genericReturnType).getActualTypeArguments()).length == 1) {
                return typeArguments[0] == Void.class;
            }
            return false;
        }).map(mcpProgressMethod -> {
            McpProgress progressAnnotation = mcpProgressMethod.getAnnotation(McpProgress.class);
            AsyncMcpProgressMethodCallback methodCallback = ((AsyncMcpProgressMethodCallback.Builder)((AsyncMcpProgressMethodCallback.Builder)((AsyncMcpProgressMethodCallback.Builder)AsyncMcpProgressMethodCallback.builder().method((Method)mcpProgressMethod)).bean(progressObject)).progress(progressAnnotation)).build();
            return new AsyncProgressSpecification(progressAnnotation.clientId(), methodCallback);
        }).toList()).flatMap(Collection::stream).toList();
        return progressHandlers;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }
}

