/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model;

import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxObjectNotInStoreException;
import org.spdx.library.model.IndividualUriValue;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.SimpleUriValue;
import org.spdx.library.model.SpdxInvalidTypeException;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.TypedValue;
import org.spdx.storage.IModelStore;

public class ModelStorageClassConverter {
    static final Logger logger = LoggerFactory.getLogger(ModelStorageClassConverter.class);
    static ModelCopyManager tempMgr = new ModelCopyManager();

    public static void reset() {
        tempMgr = new ModelCopyManager();
    }

    public static Object storedObjectToModelObject(Object value, String documentUri, IModelStore modelStore, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        if (value instanceof IndividualUriValue) {
            SimpleUriValue suv = new SimpleUriValue((IndividualUriValue)value);
            return suv.toModelObject(modelStore, documentUri, null);
        }
        if (value instanceof TypedValue) {
            TypedValue tv = (TypedValue)value;
            return SpdxModelFactory.createModelObject(modelStore, documentUri, tv.getId(), tv.getType(), copyManager);
        }
        return value;
    }

    public static Optional<Object> optionalStoredObjectToModelObject(Optional<Object> value, String stDocumentUri, IModelStore stModelStore, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        if (value.isPresent() && value.get() instanceof IndividualUriValue) {
            return Optional.of(new SimpleUriValue((IndividualUriValue)value.get()).toModelObject(stModelStore, stDocumentUri, copyManager));
        }
        if (value.isPresent() && value.get() instanceof TypedValue) {
            TypedValue tv = (TypedValue)value.get();
            return Optional.of(SpdxModelFactory.createModelObject(stModelStore, stDocumentUri, tv.getId(), tv.getType(), copyManager));
        }
        return value;
    }

    public static Object modelObjectToStoredObject(Object value, String stDocumentUri, IModelStore stModelStore, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        if (value instanceof IndividualUriValue) {
            return new SimpleUriValue((IndividualUriValue)value);
        }
        if (value instanceof ModelObject) {
            ModelObject mValue = (ModelObject)value;
            if (!mValue.getModelStore().equals(stModelStore) || !mValue.getDocumentUri().equals(stDocumentUri)) {
                if (Objects.nonNull(copyManager)) {
                    return copyManager.copy(stModelStore, stDocumentUri, mValue.getModelStore(), mValue.getDocumentUri(), mValue.getId(), mValue.getType());
                }
                throw new SpdxObjectNotInStoreException("Can not set a property value to a Model Object stored in a different model store");
            }
            return mValue.toTypedValue();
        }
        if (value instanceof Integer || value instanceof String || value instanceof Boolean || value instanceof IndividualUriValue) {
            return value;
        }
        if (Objects.isNull(value)) {
            throw new SpdxInvalidTypeException("Property value is null");
        }
        throw new SpdxInvalidTypeException("Property value type not supported: " + value.getClass().getName());
    }

    public static Class<?> modelClassToStoredClass(Class<?> clazz) {
        if (ModelObject.class.isAssignableFrom(clazz)) {
            return TypedValue.class;
        }
        if (ModelStorageClassConverter.implementsIndividualUriValue(clazz)) {
            return SimpleUriValue.class;
        }
        return clazz;
    }

    private static boolean implementsIndividualUriValue(Class<?> clazz) {
        for (Class<?> intefaceClass : clazz.getInterfaces()) {
            if (!intefaceClass.equals(IndividualUriValue.class)) continue;
            return true;
        }
        return false;
    }
}

