/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

class SSLServerSocketFactoryWrapper
extends SSLServerSocketFactory {
    private final SSLServerSocketFactory delegate;
    private final SSLParameters parameters;

    public SSLServerSocketFactoryWrapper(SSLServerSocketFactory delegate, SSLParameters parameters) {
        this.delegate = delegate;
        this.parameters = parameters;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket serverSocket = (SSLServerSocket)this.delegate.createServerSocket(port);
        serverSocket.setSSLParameters(this.parameters);
        return serverSocket;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        SSLServerSocket serverSocket = (SSLServerSocket)this.delegate.createServerSocket(port, backlog);
        serverSocket.setSSLParameters(this.parameters);
        return serverSocket;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress localAddress) throws IOException {
        SSLServerSocket serverSocket = (SSLServerSocket)this.delegate.createServerSocket(port, backlog, localAddress);
        serverSocket.setSSLParameters(this.parameters);
        return serverSocket;
    }
}

