/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.ssl;

import javax.net.ssl.SSLParameters;
import org.soulwing.ssl.OptionSet;

class SSLParametersConfiguration {
    private final OptionSet protocolOptions = new OptionSet();
    private final OptionSet cipherSuiteOptions = new OptionSet();
    private Boolean wantClientAuth;
    private Boolean needClientAuth;

    SSLParametersConfiguration() {
    }

    public void excludeProtocols(String ... protocols) {
        this.protocolOptions.excludeOptions(protocols);
    }

    public void includeProtocols(String ... protocols) {
        this.protocolOptions.includeOptions(protocols);
    }

    public void excludeCipherSuites(String ... cipherSuites) {
        this.cipherSuiteOptions.excludeOptions(cipherSuites);
    }

    public void includeCipherSuites(String ... cipherSuites) {
        this.cipherSuiteOptions.includeOptions(cipherSuites);
    }

    public void setWantClientAuth(Boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public void setNeedClientAuth(Boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public SSLParameters createParameters(SSLParameters supportedParameters, SSLParameters defaultParameters) {
        SSLParameters parameters = new SSLParameters();
        parameters.setProtocols(this.protocolOptions.enabledOptions(supportedParameters.getProtocols(), defaultParameters.getProtocols()));
        parameters.setCipherSuites(this.cipherSuiteOptions.enabledOptions(supportedParameters.getCipherSuites(), defaultParameters.getCipherSuites()));
        parameters.setWantClientAuth(this.wantClientAuth != null ? this.wantClientAuth.booleanValue() : defaultParameters.getWantClientAuth());
        parameters.setNeedClientAuth(this.needClientAuth != null ? this.needClientAuth.booleanValue() : defaultParameters.getNeedClientAuth());
        return parameters;
    }
}

