/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.ssl;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import org.soulwing.ssl.ResourceAccessor;
import org.soulwing.ssl.SSLRuntimeException;

class KeyStoreFactory {
    private String type;
    private String providerName;
    private Provider provider;
    private char[] password;
    private URL location;

    KeyStoreFactory() {
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setProvider(String providerName) {
        this.providerName = providerName;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public void setPassword(String password) {
        this.password = password != null ? password.toCharArray() : null;
    }

    public void setLocation(URL location) {
        if (location == null) {
            throw new NullPointerException("URL is required");
        }
        this.location = location;
    }

    public void setLocation(URI location) {
        try {
            URL url = ResourceAccessor.getResource(location);
            this.assertResolved(location.toString(), url);
            this.setLocation(url);
        }
        catch (MalformedURLException ex) {
            throw new SSLRuntimeException(ex);
        }
    }

    public void setLocation(String location) {
        try {
            URL url = ResourceAccessor.getResource(location);
            this.assertResolved(location, url);
            this.setLocation(url);
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new SSLRuntimeException(ex);
        }
    }

    public void setLocation(String location, Class<?> relativeToClass) {
        URL url = ResourceAccessor.getResource(location, relativeToClass);
        this.assertResolved(location, url);
        this.setLocation(url);
    }

    public void setLocation(String location, ClassLoader classLoader) {
        URL url = ResourceAccessor.getResource(location, classLoader);
        this.assertResolved(location, url);
        this.setLocation(url);
    }

    private void assertResolved(String location, URL url) {
        if (url == null) {
            throw new SSLRuntimeException("cannot resolve location: '" + location + "'");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeyStore newKeyStore() {
        try (InputStream inputStream = this.location.openStream();){
            KeyStore keyStore = this.getKeyStoreInstance();
            keyStore.load(inputStream, this.password);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SSLRuntimeException(ex);
        }
    }

    private KeyStore getKeyStoreInstance() throws KeyStoreException, NoSuchProviderException {
        String type;
        String string = type = this.type == null ? KeyStore.getDefaultType() : this.type;
        if (this.provider != null) {
            return KeyStore.getInstance(type, this.provider);
        }
        if (this.providerName != null) {
            return KeyStore.getInstance(type, this.providerName);
        }
        return KeyStore.getInstance(type);
    }
}

