/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.rules;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.annotation.Nullable;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.plugins.xml.checks.CheckRepository;
import org.sonar.squidbridge.annotations.AnnotationBasedRulesDefinition;

public final class XmlRulesDefinition
implements RulesDefinition {
    private final Gson gson = new Gson();

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repository = context.createRepository("xml", "xml").setName("SonarAnalyzer");
        new AnnotationBasedRulesDefinition(repository, "xml").addRuleClasses(false, CheckRepository.getCheckClasses());
        for (RulesDefinition.NewRule rule : repository.rules()) {
            String metadataKey = rule.key();
            rule.setInternalKey(metadataKey);
            rule.setHtmlDescription(XmlRulesDefinition.readRuleDefinitionResource(metadataKey + ".html"));
            this.addMetadata(rule, metadataKey);
        }
        repository.done();
    }

    @Nullable
    private static String readRuleDefinitionResource(String fileName) {
        URL resource = XmlRulesDefinition.class.getResource("/org/sonar/l10n/xml/rules/xml/" + fileName);
        if (resource == null) {
            return null;
        }
        try {
            return Resources.toString((URL)resource, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read " + resource, e);
        }
    }

    private void addMetadata(RulesDefinition.NewRule rule, String metadataKey) {
        String json = XmlRulesDefinition.readRuleDefinitionResource(metadataKey + ".json");
        if (json != null) {
            RuleMetadata metadata = (RuleMetadata)this.gson.fromJson(json, RuleMetadata.class);
            rule.setSeverity(metadata.defaultSeverity.toUpperCase(Locale.US));
            rule.setName(metadata.title);
            rule.setTags(metadata.tags);
            rule.setType(RuleType.valueOf((String)metadata.type));
            rule.setStatus(RuleStatus.valueOf((String)metadata.status.toUpperCase(Locale.US)));
            if (metadata.remediation != null) {
                rule.setDebtRemediationFunction(metadata.remediation.remediationFunction(rule.debtRemediationFunctions()));
                rule.setGapDescription(metadata.remediation.linearDesc);
            }
        }
    }

    private static class Remediation {
        String func;
        String constantCost;
        String linearDesc;
        String linearOffset;
        String linearFactor;

        private Remediation() {
        }

        private DebtRemediationFunction remediationFunction(RulesDefinition.DebtRemediationFunctions drf) {
            if (this.func.startsWith("Constant")) {
                return drf.constantPerIssue(this.constantCost.replace("mn", "min"));
            }
            if ("Linear".equals(this.func)) {
                return drf.linear(this.linearFactor.replace("mn", "min"));
            }
            return drf.linearWithOffset(this.linearFactor.replace("mn", "min"), this.linearOffset.replace("mn", "min"));
        }
    }

    private static class RuleMetadata {
        String title;
        String status;
        String type;
        @Nullable
        Remediation remediation;
        String[] tags;
        String defaultSeverity;

        private RuleMetadata() {
        }
    }
}

