/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.parsers;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import org.apache.commons.io.IOUtils;
import org.sonar.plugins.xml.parsers.AbstractParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class DetectSchemaParser
extends AbstractParser {
    public Doctype findDoctype(InputStream input) {
        Handler handler = new Handler();
        try {
            SAXParser parser = this.newSaxParser(false);
            XMLReader xmlReader = parser.getXMLReader();
            xmlReader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            parser.parse(input, (DefaultHandler)handler);
            Doctype doctype = handler.doctype;
            return doctype;
        }
        catch (StopParserException e) {
            Doctype doctype = handler.doctype;
            return doctype;
        }
        catch (IOException | SAXException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    private static class Handler
    extends DefaultHandler
    implements LexicalHandler {
        private Doctype doctype = new Doctype();

        private Handler() {
        }

        @Override
        public void comment(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.doctype.dtd = publicId;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.doctype.namespace = attributes.getValue("xmlns");
            throw new StopParserException();
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }
    }

    private static class StopParserException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        private StopParserException() {
        }
    }

    public static class Doctype {
        private String dtd;
        private String namespace;

        public String getDtd() {
            return this.dtd;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }
}

