/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.highlighting;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.plugins.xml.checks.XmlFile;
import org.sonar.plugins.xml.highlighting.HighlightingData;

public class XMLHighlighting {
    private static final String XML_DECLARATION_TAG = "<?xml";
    private final int delta;
    private List<HighlightingData> highlighting = new ArrayList<HighlightingData>();
    private String content;
    private int currentStartOffset = -1;
    private TypeOfText currentCode = null;
    private static final Logger LOG = LoggerFactory.getLogger(XMLHighlighting.class);

    public XMLHighlighting(XmlFile xmlFile) throws IOException {
        this.content = xmlFile.getContents();
        this.delta = xmlFile.getOffsetDelta();
        try (InputStream inputStream = xmlFile.getInputStream();){
            this.highlightXML(new InputStreamReader(inputStream, xmlFile.getCharset()));
        }
        catch (XMLStreamException e) {
            LOG.warn("Can't highlight following file : " + xmlFile.getAbsolutePath(), (Throwable)e);
        }
    }

    public XMLHighlighting(String xmlStrContent) {
        this.delta = 0;
        this.content = xmlStrContent;
        try {
            this.highlightXML(new StringReader(xmlStrContent));
        }
        catch (XMLStreamException e) {
            LOG.warn("Can't highlight following code : \n" + xmlStrContent, (Throwable)e);
        }
    }

    public List<HighlightingData> getHighlightingData() {
        return this.highlighting;
    }

    public void highlightXML(Reader reader) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", "false");
        factory.setProperty("javax.xml.stream.isReplacingEntityReferences", "false");
        XMLStreamReader xmlReader = factory.createXMLStreamReader(reader);
        this.highlightXmlDeclaration();
        while (xmlReader.hasNext()) {
            Location prevLocation = xmlReader.getLocation();
            xmlReader.next();
            int startOffset = xmlReader.getLocation().getCharacterOffset();
            this.closeHighlighting(startOffset);
            switch (xmlReader.getEventType()) {
                case 1: {
                    this.highlightStartElement(xmlReader, startOffset);
                    break;
                }
                case 2: {
                    this.highlightEndElement(xmlReader, prevLocation, startOffset);
                    break;
                }
                case 12: {
                    this.highlightCData(startOffset);
                    break;
                }
                case 11: {
                    this.highlightDTD(startOffset);
                    break;
                }
                case 5: {
                    this.addUnclosedHighlighting(startOffset, TypeOfText.STRUCTURED_COMMENT);
                    break;
                }
            }
        }
    }

    private void highlightDTD(int startOffset) {
        int closingBracketStartOffset = this.getTagClosingBracketStartOffset(startOffset);
        this.addHighlighting(startOffset, startOffset + 9, TypeOfText.STRUCTURED_COMMENT);
        this.addHighlighting(closingBracketStartOffset, closingBracketStartOffset + 1, TypeOfText.STRUCTURED_COMMENT);
    }

    private void highlightCData(int startOffset) {
        if (!this.content.substring(startOffset).startsWith("<![CDATA[")) {
            return;
        }
        int closingBracketStartOffset = this.getCDATAClosingBracketStartOffset(startOffset);
        this.addHighlighting(startOffset, startOffset + 9, TypeOfText.KEYWORD);
        this.addHighlighting(closingBracketStartOffset - 2, closingBracketStartOffset + 1, TypeOfText.KEYWORD);
    }

    private void highlightEndElement(XMLStreamReader xmlReader, Location prevLocation, int startOffset) {
        boolean isEmptyElement;
        int closingBracketStartOffset = this.getTagClosingBracketStartOffset(startOffset);
        boolean bl = isEmptyElement = prevLocation.getLineNumber() == xmlReader.getLocation().getLineNumber() && prevLocation.getColumnNumber() == xmlReader.getLocation().getColumnNumber();
        if (isEmptyElement) {
            this.addHighlighting(closingBracketStartOffset - 1, closingBracketStartOffset, TypeOfText.KEYWORD);
        } else {
            this.addHighlighting(startOffset, closingBracketStartOffset + 1, TypeOfText.KEYWORD);
        }
    }

    private void highlightStartElement(XMLStreamReader xmlReader, int startOffset) {
        int closingBracketStartOffset = this.getTagClosingBracketStartOffset(startOffset);
        int endOffset = startOffset + XMLHighlighting.getNameWithNamespaceLength(xmlReader) + 1;
        this.addHighlighting(startOffset, endOffset, TypeOfText.KEYWORD);
        this.highlightAttributes(endOffset, closingBracketStartOffset);
        this.addHighlighting(closingBracketStartOffset, closingBracketStartOffset + 1, TypeOfText.KEYWORD);
    }

    private void highlightXmlDeclaration() {
        int startOffset;
        int n = startOffset = this.content.startsWith("\ufeff") ? 1 : 0;
        if (this.content.startsWith(XML_DECLARATION_TAG, startOffset)) {
            int closingBracketStartOffset = this.getTagClosingBracketStartOffset(startOffset);
            this.addHighlighting(startOffset, startOffset + XML_DECLARATION_TAG.length(), TypeOfText.KEYWORD);
            this.highlightAttributes(startOffset + XML_DECLARATION_TAG.length(), closingBracketStartOffset);
            this.addHighlighting(closingBracketStartOffset - 1, closingBracketStartOffset + 1, TypeOfText.KEYWORD);
        }
    }

    private void highlightAttributes(int from, int to) {
        Integer startOffset = null;
        Character attributeValueQuote = null;
        for (int counter = from + 1; counter < to; ++counter) {
            char c = this.content.charAt(counter);
            if (startOffset == null && !Character.isWhitespace(c)) {
                startOffset = counter;
            }
            if (attributeValueQuote != null && attributeValueQuote.charValue() == c) {
                this.addHighlighting(startOffset, counter + 1, TypeOfText.STRING);
                ++counter;
                startOffset = null;
                attributeValueQuote = null;
            }
            if (c != '=' || attributeValueQuote != null) continue;
            this.addHighlighting(startOffset, counter, TypeOfText.CONSTANT);
            while ((c = this.content.charAt(++counter)) != '\'' && c != '\"') {
            }
            startOffset = counter;
            attributeValueQuote = Character.valueOf(c);
        }
    }

    private int getTagClosingBracketStartOffset(int startOffset) {
        return this.getClosingBracketStartOffset(startOffset, false);
    }

    private int getCDATAClosingBracketStartOffset(int startOffset) {
        return this.getClosingBracketStartOffset(startOffset, true);
    }

    private int getClosingBracketStartOffset(int startOffset, boolean isCDATA) {
        for (int counter = startOffset + 1; counter < this.content.length(); ++counter) {
            if (this.content.charAt(counter) != '>' || !this.bracketsBefore(isCDATA, counter)) continue;
            return counter;
        }
        throw new IllegalStateException("No \">\" found.");
    }

    private boolean bracketsBefore(boolean isCDATA, int counter) {
        return !isCDATA || this.content.charAt(counter - 1) == ']' && this.content.charAt(counter - 2) == ']';
    }

    private static int getNameWithNamespaceLength(XMLStreamReader streamReader) {
        int prefixLength = 0;
        if (!streamReader.getName().getPrefix().isEmpty()) {
            prefixLength = streamReader.getName().getPrefix().length() + 1;
        }
        return prefixLength + streamReader.getLocalName().length();
    }

    private void addHighlighting(int startOffset, int endOffset, TypeOfText typeOfText) {
        this.highlighting.add(new HighlightingData(startOffset + this.delta, endOffset + this.delta, typeOfText));
    }

    private void addUnclosedHighlighting(int startOffset, TypeOfText code) {
        this.currentStartOffset = startOffset;
        this.currentCode = code;
    }

    private void closeHighlighting(int endOffset) {
        if (this.currentCode != null) {
            this.addHighlighting(this.currentStartOffset, endOffset, this.currentCode);
            this.currentCode = null;
        }
    }
}

