/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.compat;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.Version;
import org.sonar.plugins.xml.compat.CompatibleInputFile;
import org.sonar.plugins.xml.compat.InputFileV56Compat;
import org.sonar.plugins.xml.compat.InputFileV60Compat;

public class CompatibilityHelper {
    public static final Version V6_0 = Version.create((int)6, (int)0);
    public static final Version V6_2 = Version.create((int)6, (int)2);

    private CompatibilityHelper() {
    }

    public static CompatibleInputFile wrap(InputFile inputFile) {
        return new CompatibleInputFile(inputFile);
    }

    public static Collection<CompatibleInputFile> wrap(Iterable<InputFile> inputFiles, SensorContext context) {
        Version version = context.getSonarQubeVersion();
        if (version.isGreaterThanOrEqual(V6_2)) {
            return CompatibilityHelper.inputFileStream(inputFiles).map(CompatibleInputFile::new).collect(Collectors.toList());
        }
        if (version.isGreaterThanOrEqual(V6_0)) {
            return CompatibilityHelper.inputFileStream(inputFiles).map(InputFileV60Compat::new).collect(Collectors.toList());
        }
        return CompatibilityHelper.inputFileStream(inputFiles).map(f -> new InputFileV56Compat((InputFile)f, context)).collect(Collectors.toList());
    }

    private static Stream<InputFile> inputFileStream(Iterable<InputFile> inputFiles) {
        return StreamSupport.stream(inputFiles.spliterator(), false);
    }
}

